/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.AppServicePlans;
import com.azure.resourcemanager.appservice.models.ConnectionStringType;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebApps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.azure.AzureCredentials;
import com.xebialabs.deployit.plugin.azure.package$;
import java.io.File;
import java.io.Serializable;
import org.python.core.PyList;
import org.python.core.PyObject;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\t\u0013\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!9q\u0007\u0001b\u0001\n\u0013A\u0004B\u0002#\u0001A\u0003%\u0011\bC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u0015\u0011\u0004\u0001\"\u0001L\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA\"\u0001\u0011%\u0011Q\t\u0002\r/\u0016\u0014\u0017\t\u001d9DY&,g\u000e\u001e\u0006\u0003'Q\tQ!\u0019>ve\u0016T!!\u0006\f\u0002\rAdWoZ5o\u0015\t9\u0002$\u0001\u0005eKBdw._5u\u0015\tI\"$A\u0005yK\nL\u0017\r\\1cg*\t1$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u0002%%\u0011\u0011E\u0005\u0002\u0011\u0003j,(/Z\"sK\u0012,g\u000e^5bYN\fQa\u00197pk\u0012\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u0007U$WN\u0003\u0002))\u0005\u0019\u0011\r]5\n\u0005)*#!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\u000691m\u001c8uKb$\bCA\u00171\u001b\u0005q#BA\u0018(\u0003\u00111Gn\\<\n\u0005Er#\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019A'\u000e\u001c\u0011\u0005}\u0001\u0001\"\u0002\u0012\u0004\u0001\u0004\u0019\u0003\"B\u0016\u0004\u0001\u0004a\u0013aB<fE\u0006\u0003\bo]\u000b\u0002sA\u0011!HQ\u0007\u0002w)\u0011A(P\u0001\u0007[>$W\r\\:\u000b\u0005yz\u0014AC1qaN,'O^5dK*\u0011\u0001)Q\u0001\u0010e\u0016\u001cx.\u001e:dK6\fg.Y4fe*\u00111CG\u0005\u0003\u0007n\u0012qaV3c\u0003B\u00048/\u0001\u0005xK\n\f\u0005\u000f]:!\u0003=\t\u0007\u000f]*feZL7-\u001a)mC:\u001cX#A$\u0011\u0005iB\u0015BA%<\u0005=\t\u0005\u000f]*feZL7-\u001a)mC:\u001c\u0018\u0001E1qaN+'O^5dKBc\u0017M\\:!)\r!D\n\u0017\u0005\u0006\u001b\"\u0001\rAT\u0001\baf\u001cEn\\;e!\tye+D\u0001Q\u0015\t\t&+\u0001\u0003d_J,'BA*U\u0003\u0019\u0001\u0018\u0010\u001e5p]*\tQ+A\u0002pe\u001eL!a\u0016)\u0003\u0011AKxJ\u00196fGRDQa\u000b\u0005A\u00021\n1aZ3u)\rYf,\u001c\t\u0003uqK!!X\u001e\u0003\r]+'-\u00119q\u0011\u0015y\u0016\u00021\u0001a\u0003E\u0011Xm]8ve\u000e,wI]8va:\u000bW.\u001a\t\u0003C*t!A\u00195\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015d\u0012A\u0002\u001fs_>$hHC\u0001h\u0003\u0015\u00198-\u00197b\u0013\tIg-\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5g\u0011\u0015q\u0017\u00021\u0001a\u0003)9XMY!qa:\u000bW.Z\u0001\u000fGJ,\u0017\r^3PeV\u0003H-\u0019;f)!\tXO^<z}\u0006\u0005\u0001C\u0001:t\u001b\u00051\u0017B\u0001;g\u0005\u0011)f.\u001b;\t\u000b9T\u0001\u0019\u00011\t\u000b}S\u0001\u0019\u00011\t\u000baT\u0001\u0019\u00011\u0002%\u0005\u0004\boU3sm&\u001cW\r\u00157b]:\u000bW.\u001a\u0005\u0006u*\u0001\ra_\u0001\fCB\u00048+\u001a;uS:<7\u000f\u0005\u0002Py&\u0011Q\u0010\u0015\u0002\u0007!fd\u0015n\u001d;\t\u000b}T\u0001\u0019A>\u0002\u000f\u0005\u0004\b\u000fV1hg\"1\u00111\u0001\u0006A\u0002m\f\u0011cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4t\u0003\u0019!W\r\\3uKR)\u0011/!\u0003\u0002\f!)ql\u0003a\u0001A\")an\u0003a\u0001A\u00061Q\u000f\u001d7pC\u0012$r!]A\t\u0003'\t)\u0002C\u0003`\u0019\u0001\u0007\u0001\rC\u0003o\u0019\u0001\u0007\u0001\r\u0003\u0004\u0002\u00181\u0001\r\u0001Y\u0001\u0005a\u0006$\b.\u0001\u0004fq&\u001cHo\u001d\u000b\u0007\u0003;\t\u0019#!\n\u0011\u0007I\fy\"C\u0002\u0002\"\u0019\u0014qAQ8pY\u0016\fg\u000eC\u0003`\u001b\u0001\u0007\u0001\r\u0003\u0004\u0002(5\u0001\r\u0001Y\u0001\u0005]\u0006lW-\u0001\fbaB\u001cV\r\u001e;j]\u001e\u001cHk\\*dC2\fG*[:u)\u0015\t\u0018QFA\u0018\u0011\u0015Qh\u00021\u0001|\u0011\u001d\t\tD\u0004a\u0001\u0003g\tab^5uQ\u0006\u0003\boU3ui&tw\r\u0005\u0004s\u0003k\u0001\u0007-]\u0005\u0004\u0003o1'!\u0003$v]\u000e$\u0018n\u001c83\u0003I\t\u0007\u000f\u001d+bON$vnU2bY\u0006d\u0015n\u001d;\u0015\u000bE\fi$a\u0010\t\u000b}|\u0001\u0019A>\t\u000f\u0005\u0005s\u00021\u0001\u00024\u00059q/\u001b;i)\u0006<\u0017\u0001H2p]:,7\r^5p]N#(/\u001b8hgR{7kY1mC2K7\u000f\u001e\u000b\u0006c\u0006\u001d\u0013\u0011\n\u0005\u0007\u0003\u0007\u0001\u0002\u0019A>\t\u000f\u0005-\u0003\u00031\u0001\u0002N\u0005!r/\u001b;i\u0007>tg.Z2uS>t7\u000b\u001e:j]\u001e\u0004\u0002B]A(A\u0002\f\u0019&]\u0005\u0004\u0003#2'!\u0003$v]\u000e$\u0018n\u001c84!\rQ\u0014QK\u0005\u0004\u0003/Z$\u0001F\"p]:,7\r^5p]N#(/\u001b8h)f\u0004X\r")
public class WebAppClient
extends AzureCredentials {
    private final WebApps webApps = this.azure().webApps();
    private final AppServicePlans appServicePlans = this.azure().appServicePlans();

    private WebApps webApps() {
        return this.webApps;
    }

    private AppServicePlans appServicePlans() {
        return this.appServicePlans;
    }

    public WebApp get(String resourceGroupName, String webAppName) {
        WebApp webApp;
        try {
            webApp = (WebApp)this.webApps().getByResourceGroup(resourceGroupName, webAppName);
        }
        catch (Exception exception) {
            webApp = null;
        }
        return webApp;
    }

    public void createOrUpdate(String webAppName, String resourceGroupName, String appServicePlanName, PyList appSettings, PyList appTags, PyList connectionStrings) {
        AppServicePlan servicePlan = (AppServicePlan)this.appServicePlans().getByResourceGroup(resourceGroupName, appServicePlanName);
        if (servicePlan == null) {
            throw new RuntimeException(new StringBuilder(45).append("Service plan ").append(appServicePlanName).append(" not found under Resource group ").append(resourceGroupName).toString());
        }
        String operation = "";
        operation = this.get(resourceGroupName, webAppName) != null ? "updated" : "created";
        WebApp.DefinitionStages.WithWindowsAppFramework webApp = ((WebApp.DefinitionStages.Blank)this.webApps().define(webAppName)).withExistingWindowsPlan(servicePlan).withExistingResourceGroup(resourceGroupName);
        this.appSettingsToScalaList(appSettings, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(x$1, x$2) -> {
            webApp.withAppSetting(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        this.appTagsToScalaList(appTags, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(x$1, x$2) -> {
            webApp.withTag(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        this.connectionStringsToScalaList(connectionStrings, (Function3<String, String, ConnectionStringType, BoxedUnit>)(Function3 & Serializable)(x$1, x$2, x$3) -> {
            webApp.withConnectionString(x$1, x$2, x$3);
            return BoxedUnit.UNIT;
        });
        webApp.create();
        this.logOutput(new StringBuilder(33).append("Web App '").append(webAppName).append("' ").append(operation).append(" on Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    public void delete(String resourceGroupName, String webAppName) {
        this.webApps().deleteByResourceGroup(resourceGroupName, webAppName);
        this.logOutput(new StringBuilder(42).append("Web App '").append(webAppName).append("' deleted from Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    public void upload(String resourceGroupName, String webAppName, String path) {
        WebApp webApp = (WebApp)this.webApps().getByResourceGroup(resourceGroupName, webAppName);
        File file = new File(path);
        if (file.getName().endsWith(".war")) {
            webApp.warDeploy(file);
            this.logOutput(new StringBuilder(53).append("WAR file deployed to web app '").append(webAppName).append("' on Resource Group '").append(resourceGroupName).append("'.").toString());
        } else {
            webApp.zipDeploy(file);
            this.logOutput(new StringBuilder(53).append("ZIP file deployed to web app '").append(webAppName).append("' on Resource Group '").append(resourceGroupName).append("'.").toString());
        }
    }

    public boolean exists(String resourceGroupName, String name) {
        return this.webApps().getByResourceGroup(resourceGroupName, name) != null;
    }

    private void appSettingsToScalaList(PyList appSettings, Function2<String, String, BoxedUnit> withAppSetting) {
        appSettings.stream().map(x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withAppSetting.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "value", package$.MODULE$.getPyObjectStringAttr$default$3()));
            } else {
                object = None$.MODULE$;
            }
            return object;
        });
    }

    private void appTagsToScalaList(PyList appTags, Function2<String, String, BoxedUnit> withTag) {
        appTags.stream().map(x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withTag.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "value", package$.MODULE$.getPyObjectStringAttr$default$3()));
            } else {
                object = None$.MODULE$;
            }
            return object;
        });
    }

    private void connectionStringsToScalaList(PyList connectionStrings, Function3<String, String, ConnectionStringType, BoxedUnit> withConnectionString) {
        connectionStrings.stream().map(x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withConnectionString.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "connection_string", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)ConnectionStringType.fromString((String)package$.MODULE$.getPyObjectStringAttr(pyObject, "type", package$.MODULE$.getPyObjectStringAttr$default$3())));
            } else {
                object = None$.MODULE$;
            }
            return object;
        });
    }

    public WebAppClient(ConfigurationItem cloud, ExecutionContext context) {
        super(cloud, context);
    }

    public WebAppClient(PyObject pyCloud, ExecutionContext context) {
        this(package$.MODULE$.getAzureCloudFromPyObject(pyCloud), context);
    }
}

