import xml.etree.ElementTree as ET
import requests

from xld.azure.connector import AzureConnector

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
web_app_name = previousDeployed.webAppName
web_job_name = previousDeployed.webJobName or previousDeployed.name

print "Deleting Web Job {0} from Web App {1} under Resource Group {2}".format(web_job_name, web_app_name,  resource_group_name)

# synchronous
credentials = web_client.web_apps.list_publishing_profile_xml_with_secrets(
    resource_group_name=resource_group_name,
    name=web_app_name,
    format='Ftp'
)

#Parse credentials from XML
root = ET.XML(''.join(credentials))
for publishProfile in root:
    if publishProfile.attrib['publishMethod'] == 'MSDeploy':
        api_username = publishProfile.attrib['userName']
        api_password = publishProfile.attrib['userPWD']

api_url="https://" + web_app_name + ".scm.azurewebsites.net/api/" + previousDeployed.jobType + "/" + web_job_name

r = requests.delete(url=api_url, auth=(api_username, api_password))

logger.info("Result: {0}".format(r))
