# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureBlobStorageHttpLogsConfig(Model):
    """Http logs to azure blob storage configuration.

    :param sas_url: SAS url to a azure blob container with
     read/write/list/delete permissions.
    :type sas_url: str
    :param retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    :param enabled: True if configuration is enabled, false if it is disabled
     and null if configuration is not set.
    :type enabled: bool
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, sas_url=None, retention_in_days=None, enabled=None):
        super(AzureBlobStorageHttpLogsConfig, self).__init__()
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days
        self.enabled = enabled
