from java.io import BufferedReader
from java.io import InputStreamReader
from java.io import ByteArrayInputStream
from java.lang import StringBuilder
from java.lang import RuntimeException
from java.lang import String

class TemplateHelper(object):
    def __init__(self, deployed, template, stitch):
        self.__deployed = deployed
        self.__template = template
        self.__stitch = stitch

    def transform_template(self):
        try:
            invocation_name = "Transform {} template".format(self.__deployed.name)
            transformer_context = {"format": "json", "invocationName": invocation_name}
            transformed_content = self.__stitch(ByteArrayInputStream(String(self.__template).getBytes()), transformer_context)
            print('Template transformation applied for {}'.format(self.__deployed.name))
            return self.stringify(transformed_content)
        except RuntimeException as e:
            if e.getMessage() is not None:
                msg = e.getMessage
            else:
                msg = e.toString
            print("Planning script could not apply template transformation. Reason: {}".format(msg))
            return template

    def stringify(self, stream):
        reader = BufferedReader(InputStreamReader(stream))
        out = StringBuilder()

        while True:
            line = reader.readLine()
            if line is None:
                break
            out.append(line)
            out.append("\n")

        reader.close()
        return out.toString()
