/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.net.util.SubnetUtils;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="azure-network-address")
@ApplicableTo(value={PropertyKind.STRING})
public @interface NetworkAddress {
    public static final String DEFAULT_MESSAGE = "Address '%s' is not valid";
    public static final boolean DEFAULT_ALLOW_MASK = true;
    public static final boolean DEFAULT_ALLOW_WILDCARD = false;

    public String message() default "Address '%s' is not valid";

    public boolean allowMask() default true;

    public boolean allowWildcard() default false;

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        private String message = "Address '%s' is not valid";
        private boolean allowMask = true;
        private boolean allowWildcard = false;

        public void validate(String value, ValidationContext context) {
            if (value == null) {
                return;
            }
            if (!Validator.isValidAddress(value, this.allowMask, this.allowWildcard)) {
                context.error(this.message, new Object[]{value});
            }
        }

        static boolean isValidAddress(String address, boolean allowMask, boolean allowWildcard) {
            if (allowWildcard && address.equals("*")) {
                return true;
            }
            try {
                if (allowMask && !address.contains("/") || !allowMask && address.contains("/")) {
                    return false;
                }
                Object cidr = address.contains("/") ? address : address + "/32";
                SubnetUtils su = new SubnetUtils((String)cidr);
                return su.getInfo().getAddress().equals(su.getInfo().getNetworkAddress());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

