from com.xebialabs.deployit.plugin.api.reflect import Type


class ResourceMapper(object):
    def __init__(self, _types):
        self.types = _types

    def types_supported(self, resource_type):
        for t in self.types:
            if not Type.valueOf(t).exists():
                print("Could not create CI for '%s' because '%s' type does not exist. " % (resource_type, t) +
                      "Please, include the plugin that adds support to it.")
                return False
        return True

    def _create_ci(self, _type, id, properties):
        ci = Type.valueOf(_type).getDescriptor().newInstance(id)
        for property in properties:
            ci.setProperty(property, properties[property])
        return ci
