from azure.mgmt.web.models import NameValuePair, ConnStringInfo
from xld.azure import get_operation_name

from com.xebialabs.deployit.plugin.azure import WebAppClient

rg = deployed.container
cloud = rg.container

azure_web_app_client = WebAppClient(cloud, context)

resource_group_name = rg.resourceGroupName or rg.name
web_app_name = deployed.appName or deployed.name

print "{0} Web App {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    web_app_name,
    resource_group_name)

web_app_settings = []
if deployed.appSettings.keys():
    for key,value in deployed.appSettings.items():
            web_app_settings.append(NameValuePair(name=key, value=value))

web_app_conn_strings = []
if deployed.sqlDatabaseConnectionStrings.keys() or deployed.sqlServerConnectionStrings.keys() or deployed.customConnectionStrings.keys():
    for key,value in deployed.sqlDatabaseConnectionStrings.items():
            web_app_conn_strings.append(ConnStringInfo(name=key, connection_string=value, type='SQLAzure'))
    for key,value in deployed.sqlServerConnectionStrings.items():
            web_app_conn_strings.append(ConnStringInfo(name=key, connection_string=value, type='SQLServer'))
    for key,value in deployed.customConnectionStrings.items():
            web_app_conn_strings.append(ConnStringInfo(name=key, connection_string=value, type='Custom'))

azure_web_app_client.createOrUpdate(
    web_app_name,
    resource_group_name,
    deployed.servicePlanName,
    web_app_settings,
    web_app_conn_strings
)
