/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.GenericResources;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.ResourceGroups;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.azure.AzureCredentials;
import com.xebialabs.deployit.plugin.azure.package$;
import java.io.Serializable;
import java.util.Map;
import org.python.core.PyNone;
import org.python.core.PyObject;
import scala.Function1;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004BB$\u0001A\u0003%A\bC\u0004I\u0001\t\u0007I\u0011B%\t\r5\u0003\u0001\u0015!\u0003K\u0011\u0015)\u0004\u0001\"\u0001O\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003;\u0001A\u0011AA%\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!a\u0015\u0001\t\u0013\t)FA\nSKN|WO]2f\u000fJ|W\u000f]\"mS\u0016tGO\u0003\u0002\u0017/\u0005)\u0011M_;sK*\u0011\u0001$G\u0001\u0007a2,x-\u001b8\u000b\u0005iY\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005qi\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005q\u0012aA2p[\u000e\u00011C\u0001\u0001\"!\t\u00113%D\u0001\u0016\u0013\t!SC\u0001\tBuV\u0014Xm\u0011:fI\u0016tG/[1mg\u0006)1\r\\8vIB\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0004k\u0012l'BA\u0016\u0018\u0003\r\t\u0007/[\u0005\u0003[!\u0012\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0016\u0002\t\u0019dwn^\u0005\u0003iE\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\r9\u0004(\u000f\t\u0003E\u0001AQ!J\u0002A\u0002\u0019BQAL\u0002A\u0002=\naB]3t_V\u00148-Z$s_V\u00048/F\u0001=!\tiT)D\u0001?\u0015\ty\u0004)A\u0005sKN|WO]2fg*\u0011\u0011IQ\u0001\u000b[\u0006t\u0017mZ3nK:$(B\u0001\fD\u0015\t!U$A\u0005nS\u000e\u0014xn]8gi&\u0011aI\u0010\u0002\u000f%\u0016\u001cx.\u001e:dK\u001e\u0013x.\u001e9t\u0003=\u0011Xm]8ve\u000e,wI]8vaN\u0004\u0013\u0001E4f]\u0016\u0014\u0018n\u0019*fg>,(oY3t+\u0005Q\u0005CA\u001fL\u0013\taeH\u0001\tHK:,'/[2SKN|WO]2fg\u0006\tr-\u001a8fe&\u001c'+Z:pkJ\u001cWm\u001d\u0011\u0015\u0007]z5\fC\u0003Q\u0011\u0001\u0007\u0011+A\u0004qs\u000ecw.\u001e3\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016\u0001B2pe\u0016T!AV,\u0002\rALH\u000f[8o\u0015\u0005A\u0016aA8sO&\u0011!l\u0015\u0002\t!f|%M[3di\")a\u0006\u0003a\u0001_\u00051Q\r_5tiN$\"A\u00183\u0011\u0005}\u0013W\"\u00011\u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0003\u000f\t{w\u000e\\3b]\")Q-\u0003a\u0001M\u0006\t\"/Z:pkJ\u001cWm\u0012:pkBt\u0015-\\3\u0011\u0005\u001dtgB\u00015m!\tI\u0007-D\u0001k\u0015\tYw$\u0001\u0004=e>|GOP\u0005\u0003[\u0002\fa\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q\u000eY\u0001\u0007GJ,\u0017\r^3\u0015\tM4x/\u001f\t\u0003?RL!!\u001e1\u0003\tUs\u0017\u000e\u001e\u0005\u0006K*\u0001\rA\u001a\u0005\u0006q*\u0001\rAZ\u0001\u0007e\u0016<\u0017n\u001c8\t\u000biT\u0001\u0019A>\u0002\tQ\fwm\u001d\t\u0006y\u0006\raMZ\u0007\u0002{*\u0011ap`\u0001\u0005kRLGN\u0003\u0002\u0002\u0002\u0005!!.\u0019<b\u0013\r\t)! \u0002\u0004\u001b\u0006\u0004\u0018AB;qI\u0006$X\rF\u0004t\u0003\u0017\ti!a\u0004\t\u000b\u0015\\\u0001\u0019\u00014\t\u000ba\\\u0001\u0019\u00014\t\u000bi\\\u0001\u0019A>\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002\u0016\u0005m\u0001cA\u001f\u0002\u0018%\u0019\u0011\u0011\u0004 \u0003\u001bI+7o\\;sG\u0016<%o\\;q\u0011\u0015)G\u00021\u0001g\u0003\u0019!W\r\\3uKR\u00191/!\t\t\u000b\u0015l\u0001\u0019\u00014\u0002+!\f7\u000fR3qK:$WM\u001c;SKN|WO]2fgR\u0019a,a\n\t\u000b\u0015t\u0001\u0019\u00014\u0002+\u001d,G\u000fR3qK:$WM\u001c;SKN|WO]2fgR!\u0011QFA\u001e!\u0019\ty#!\r\u000265\t!)C\u0002\u00024\t\u0013\u0011\u0002U1hK\u0012d\u0015n\u001d;\u0011\u0007u\n9$C\u0002\u0002:y\u0012qbR3oKJL7MU3t_V\u00148-\u001a\u0005\u0006K>\u0001\rAZ\u0001\u000fGJ,\u0017\r^3PeV\u0003H-\u0019;f)\u0015\u0019\u0018\u0011IA#\u0011\u0019\t\u0019\u0005\u0005a\u0001#\u0006AA-\u001a9m_f,G\r\u0003\u0004\u0002HA\u0001\r!U\u0001\u0011aJ,g/[8vg\u0012+\u0007\u000f\\8zK\u0012$2a]A&\u0011\u0019\t9%\u0005a\u0001#\u0006A2\r[3dW\u0012+\u0007/\u001a8eK:$8/\u00118e\t\u0016dW\r^3\u0015\u0007M\f\t\u0006C\u0003f%\u0001\u0007a-\u0001\u000bhKR\u0014Vm]8ve\u000e,wI]8va:\u000bW.\u001a\u000b\u0004M\u0006]\u0003BBA\"'\u0001\u0007\u0011\u000b")
public class ResourceGroupClient
extends AzureCredentials {
    private final ResourceGroups resourceGroups = this.azure().resourceGroups();
    private final GenericResources genericResources = this.azure().genericResources();

    private ResourceGroups resourceGroups() {
        return this.resourceGroups;
    }

    private GenericResources genericResources() {
        return this.genericResources;
    }

    public boolean exists(String resourceGroupName) {
        return this.resourceGroups().contain(resourceGroupName);
    }

    public void create(String resourceGroupName, String region, Map<String, String> tags) {
        ((Creatable)((Resource.DefinitionWithTags)((Resource.DefinitionWithRegion)this.resourceGroups().define(resourceGroupName)).withRegion(region)).withTags(tags)).create();
        this.logOutput(new StringBuilder(26).append("Resource Group '").append(resourceGroupName).append("' created.").toString());
    }

    public void update(String resourceGroupName, String region, Map<String, String> tags) {
        ((Appliable)((Resource.UpdateWithTags)((Updatable)this.resourceGroups().getByName(resourceGroupName)).update()).withTags(tags)).apply();
        this.logOutput(new StringBuilder(26).append("Resource Group '").append(resourceGroupName).append("' updated.").toString());
    }

    public ResourceGroup get(String resourceGroupName) {
        return (ResourceGroup)this.resourceGroups().getByName(resourceGroupName);
    }

    public void delete(String resourceGroupName) {
        this.logOutput(new StringBuilder(50).append("Deleting Resource Group '").append(resourceGroupName).append("' under SubscriptionId '").append(this.subscriptionId()).append("'").toString());
        this.resourceGroups().beginDeleteByName(resourceGroupName);
    }

    public boolean hasDependentResources(String resourceGroupName) {
        return !this.genericResources().listByResourceGroup(resourceGroupName).isEmpty();
    }

    public PagedList<GenericResource> getDependentResources(String resourceGroupName) {
        return this.genericResources().listByResourceGroup(resourceGroupName);
    }

    public void createOrUpdate(PyObject deployed, PyObject previousDeployed) {
        String resourceGroupName = this.getResourceGroupName(deployed);
        String region = package$.MODULE$.getPyObjectStringAttr(deployed, "location", package$.MODULE$.getPyObjectStringAttr$default$3());
        Map<String, String> tags = package$.MODULE$.getPyObjectMapStringStringAttr(deployed, "resourceGroupTags", package$.MODULE$.getPyObjectMapStringStringAttr$default$3());
        if (previousDeployed == null || previousDeployed instanceof PyNone) {
            this.logOutput(new StringBuilder(50).append("Creating Resource Group '").append(resourceGroupName).append("' under SubscriptionId '").append(this.subscriptionId()).append("'").toString());
            this.create(resourceGroupName, region, tags);
        } else {
            String previousRGName = this.getResourceGroupName(previousDeployed);
            Checks.checkArgument((boolean)resourceGroupName.equals(previousRGName), (String)new StringBuilder(61).append("Resource group name is not allowed to change on update (").append(previousRGName).append(" -> ").append(resourceGroupName).append(")").toString(), (Object[])new Object[0]);
            String previousRegion = package$.MODULE$.getPyObjectStringAttr(previousDeployed, "location", package$.MODULE$.getPyObjectStringAttr$default$3());
            Checks.checkArgument((boolean)region.equals(previousRegion), (String)new StringBuilder(51).append("Location is not allowed to change on update (").append(previousRegion).append(" -> ").append(region).append(")!").toString(), (Object[])new Object[0]);
            this.logOutput(new StringBuilder(50).append("Updating Resource Group '").append(resourceGroupName).append("' under SubscriptionId '").append(this.subscriptionId()).append("'").toString());
            this.update(resourceGroupName, region, tags);
        }
    }

    public void delete(PyObject previousDeployed) {
        this.checkDependentsAndDelete(this.getResourceGroupName(previousDeployed));
    }

    public void checkDependentsAndDelete(String resourceGroupName) {
        block1: {
            if (!this.exists(resourceGroupName)) break block1;
            PagedList<GenericResource> dependentResources = this.getDependentResources(resourceGroupName);
            if (!dependentResources.isEmpty()) {
                dependentResources.loadAll();
                String names = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(dependentResources).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.id(), Iterable$.MODULE$.canBuildFrom())).mkString("  \n");
                throw new RuntimeException(new StringBuilder(43).append("Resource Group '").append(resourceGroupName).append("' has dependent resources:\n").append(names).toString());
            }
            this.delete(resourceGroupName);
        }
    }

    private String getResourceGroupName(PyObject deployed) {
        return package$.MODULE$.getPyObjectStringAttr(deployed, "resourceGroupName", package$.MODULE$.getPyObjectStringAttr(deployed, "name", package$.MODULE$.getPyObjectStringAttr$default$3()));
    }

    public ResourceGroupClient(ConfigurationItem cloud, ExecutionContext context) {
        super(cloud, context);
    }

    public ResourceGroupClient(PyObject pyCloud, ExecutionContext context) {
        this(package$.MODULE$.getAzureCloudFromPyObject(pyCloud), context);
    }
}

