/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure.keyvault;

import com.xebialabs.deployit.plugin.api.udm.AbstractDictionary;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.azure.keyvault.Server;
import java.util.List;
import java.util.Map;
import scala.reflect.ScalaSignature;

@Metadata(root=Metadata.ConfigurationItemRoot.ENVIRONMENTS, description="An Azure Keyvault Secrets Manager Dictionary which contains variable IDs in which secrets are stored.")
@TypeIcon(value="icons/types/udm.Dictionary.svg")
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\b\u0010\u0001qAQ!\n\u0001\u0005\u0002\u0019B\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0001\u0016\t\u00139\u0002\u0001\u0019!a\u0001\n\u0003y\u0003\"\u0003\u001d\u0001\u0001\u0004\u0005\t\u0015)\u0003,\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015q\u0005\u0001\"\u0001P\u0011%\u0011\u0006\u00011AA\u0002\u0013\u00051\u000bC\u0005h\u0001\u0001\u0007\t\u0019!C\u0001Q\"I!\u000e\u0001a\u0001\u0002\u0003\u0006K\u0001\u0016\u0005\u0006c\u0002!\tA\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\u0006q\u0002!\t%\u001f\u0005\u0006y\u0002!\t% \u0002\u000b\t&\u001cG/[8oCJL(B\u0001\t\u0012\u0003!YW-\u001f<bk2$(B\u0001\n\u0014\u0003\u0015\t'0\u001e:f\u0015\t!R#\u0001\u0004qYV<\u0017N\u001c\u0006\u0003-]\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u00031e\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\t1aY8n\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013aA;e[*\u0011!eE\u0001\u0004CBL\u0017B\u0001\u0013 \u0005I\t%m\u001d;sC\u000e$H)[2uS>t\u0017M]=\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005y\u0011\u0001F1{kJ,7*Z=wCVdG/T1oC\u001e,'/F\u0001,!\tAC&\u0003\u0002.\u001f\t11+\u001a:wKJ\f\u0001$\u0019>ve\u0016\\U-\u001f<bk2$X*\u00198bO\u0016\u0014x\fJ3r)\t\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003V]&$\bbB\u001c\u0004\u0003\u0003\u0005\raK\u0001\u0004q\u0012\n\u0014!F1{kJ,7*Z=wCVdG/T1oC\u001e,'\u000f\t\u0015\u0003\ti\u0002\"a\u000f \u000e\u0003qR!!\u0010\u001a\u0002\u000b\t,\u0017M\\:\n\u0005}b$\u0001\u0004\"fC:\u0004&o\u001c9feRL\bF\u0002\u0003B\t\u0016;\u0005\n\u0005\u0002\u001f\u0005&\u00111i\b\u0002\t!J|\u0007/\u001a:us\u0006)A.\u00192fY\u0006\na)\u0001\fBuV\u0014X\rI&fsZ\fW\u000f\u001c;!\u001b\u0006t\u0017mZ3s\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003%\u000b\u0001!A\fhKR\f%0\u001e:f\u0017\u0016Lh/Y;mi6\u000bg.Y4feR\t1\u0006\u000b\u0002\u0006\u001b.\u0001\u0011aF:fi\u0006SXO]3LKf4\u0018-\u001e7u\u001b\u0006t\u0017mZ3s)\t\u0001\u0004\u000bC\u00048\r\u0005\u0005\t\u0019A\u0016)\u0005\u0019i\u0015aC:fGJ,GOT1nKN,\u0012\u0001\u0016\t\u0004+jcV\"\u0001,\u000b\u0005]C\u0016\u0001B;uS2T\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\-\n!A*[:u!\tiFM\u0004\u0002_EB\u0011qLM\u0007\u0002A*\u0011\u0011mG\u0001\u0007yI|w\u000e\u001e \n\u0005\r\u0014\u0014A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u0019\u001a\u0002\u001fM,7M]3u\u001d\u0006lWm]0%KF$\"\u0001M5\t\u000f]B\u0011\u0011!a\u0001)\u0006a1/Z2sKRt\u0015-\\3tA!\u0012\u0011B\u000f\u0015\u0007\u0013\u0005#UnR8\"\u00039\fAbU3de\u0016$\bET1nKN\f\u0013\u0001]\u0001<\u0003\u0002b\u0017n\u001d;!_\u001a\u00043/Z2sKR\u0004c.Y7fg\u0002Jg\u000eI<iS\u000eD\u0007e[3z[Y\fG.^3!a\u0006L'o\u001d\u0011be\u0016\u00043\u000f^8sK\u0012t\u0013AD4fiN+7M]3u\u001d\u0006lWm\u001d\u000b\u0002)\"\u0012!\"T\u0001\u000fg\u0016$8+Z2sKRt\u0015-\\3t)\t\u0001d\u000fC\u00048\u0017\u0005\u0005\t\u0019\u0001+)\u0005-i\u0015\u0001C4fiZ\u000bG.^3\u0015\u0005qS\b\"B>\r\u0001\u0004a\u0016!C:fGJ,GoS3z\u0003)9W\r^#oiJLWm\u001d\u000b\u0002}B!Qk /]\u0013\r\t\tA\u0016\u0002\u0004\u001b\u0006\u0004\bf\u0002\u0001\u0002\u0006\u0005-\u0011Q\u0002\t\u0004=\u0005\u001d\u0011bAA\u0005?\tAA+\u001f9f\u0013\u000e|g.A\u0003wC2,X-\t\u0002\u0002\u0010\u0005q\u0012nY8og>\"\u0018\u0010]3t_U$WN\f#jGRLwN\\1ss:\u001aho\u001a\u0015\u000b\u0001\u0005M\u0011\u0011DA\u000e\u000f\u0006%\u0002c\u0001\u0010\u0002\u0016%\u0019\u0011qC\u0010\u0003\u00115+G/\u00193bi\u0006\fAA]8pi\u0012\u0012\u0011QD\u0005\u0005\u0003?\t\t#\u0001\u0007F\u001dZK%k\u0014(N\u000b:#6K\u0003\u0003\u0002$\u0005\u0015\u0012!F\"p]\u001aLw-\u001e:bi&|g.\u0013;f[J{w\u000e\u001e\u0006\u0004\u0003Oy\u0012\u0001C'fi\u0006$\u0017\r^1\"\u0005\u0005-\u0012!Z!oA\u0005SXO]3!\u0017\u0016Lh/Y;mi\u0002\u001aVm\u0019:fiN\u0004S*\u00198bO\u0016\u0014\b\u0005R5di&|g.\u0019:zA]D\u0017n\u00195!G>tG/Y5og\u00022\u0018M]5bE2,\u0007%\u0013#tA%t\u0007e\u001e5jG\"\u00043/Z2sKR\u001c\b%\u0019:fAM$xN]3e]\u0001")
public class Dictionary
extends AbstractDictionary {
    @Property(label="Azure Keyvault Manager", description="")
    private Server azureKeyvaultManager;
    @Property(label="Secret Names", description="A list of secret names in which key-value pairs are stored.")
    private List<String> secretNames;

    public Server azureKeyvaultManager() {
        return this.azureKeyvaultManager;
    }

    public void azureKeyvaultManager_$eq(Server x$1) {
        this.azureKeyvaultManager = x$1;
    }

    public List<String> secretNames() {
        return this.secretNames;
    }

    public void secretNames_$eq(List<String> x$1) {
        this.secretNames = x$1;
    }

    public String getValue(String secretKey) {
        return this.azureKeyvaultManager().operations().readSecretValue(secretKey);
    }

    public Map<String, String> getEntries() {
        return this.azureKeyvaultManager().getEntries(this.secretNames());
    }

    public Server getAzureKeyvaultManager() {
        return this.azureKeyvaultManager();
    }

    public List<String> getSecretNames() {
        return this.secretNames();
    }

    public void setAzureKeyvaultManager(Server x$1) {
        this.azureKeyvaultManager_$eq(x$1);
    }

    public void setSecretNames(List<String> x$1) {
        this.secretNames_$eq(x$1);
    }
}

