/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure.keyvault;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import java.net.InetSocketAddress;

public class KeyVaultHelper {
    private String subscriptionId;
    private String tenantId;
    private String clientId;
    private String clientKey;
    private String userName;
    private String userPassword;
    private String proxyHost;
    private String proxyProtocol;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private SecretClient secretClient = null;

    public KeyVaultHelper(String tenantId, String clientId, String clientKey, String subscriptionId, String proxyHost, String proxyProtocol, String proxyPort, String proxyUser, String proxyPassword) {
        this.subscriptionId = subscriptionId;
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientKey = clientKey;
        this.proxyHost = proxyHost;
        this.proxyProtocol = proxyProtocol;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    public KeyVaultHelper(String userName, String userPassword, String subscriptionId, String proxyHost, String proxyProtocol, String proxyPort, String proxyUser, String proxyPassword) {
        this.subscriptionId = subscriptionId;
        this.userName = userName;
        this.userPassword = userPassword;
        this.proxyHost = proxyHost;
        this.proxyProtocol = proxyProtocol;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    public SecretClient getClient(String vaultName) {
        String keyVaultUri = "https://" + vaultName + ".vault.azure.net";
        ProxyOptions proxyOptions = null;
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.clientId)).clientSecret(this.clientKey).tenantId(this.tenantId)).build();
        HttpClient nettyClient = null;
        if (this.isNotEmpty(this.proxyHost) && this.isNotEmpty(this.proxyPort) && this.isNotEmpty(this.proxyHost)) {
            proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(this.proxyHost, Integer.parseInt(this.proxyPort)));
            if (this.isNotEmpty(this.proxyUser) && this.isNotEmpty(this.proxyPassword)) {
                proxyOptions.setCredentials(this.proxyUser, this.proxyPassword);
            }
            nettyClient = new NettyAsyncHttpClientBuilder().proxy(new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(this.proxyHost, Integer.parseInt(this.proxyPort)))).build();
        } else {
            nettyClient = new NettyAsyncHttpClientBuilder().build();
        }
        this.secretClient = new SecretClientBuilder().vaultUrl(keyVaultUri).credential((TokenCredential)clientSecretCredential).httpClient(nettyClient).buildClient();
        return this.secretClient;
    }

    public boolean isNotEmpty(String inputValue) {
        return inputValue != null && inputValue.length() > 0;
    }
}

