/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.aws.secretmanager;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public class SecretManagerHelper {
    private String accessKey;
    private String secretKey;
    private String sessionToken;
    private String region;
    private String proxyProtocol;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public SecretManagerHelper(String accessKey, String secretKey, String sessionToken, String region, String proxyProtocol, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
        this.region = region;
        this.proxyProtocol = proxyProtocol;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    public SecretsManagerClient createClient() throws URISyntaxException {
        Object credentialsProvider = null;
        if (this.sessionToken != null) {
            if (this.accessKey != null && this.secretKey != null) {
                credentialsProvider = new AwsCredentialsProvider(){

                    public AwsCredentials resolveCredentials() {
                        return AwsSessionCredentials.create((String)SecretManagerHelper.this.accessKey, (String)SecretManagerHelper.this.secretKey, (String)SecretManagerHelper.this.sessionToken);
                    }
                };
            }
        } else if (this.accessKey != null && this.secretKey != null) {
            credentialsProvider = new AwsCredentialsProvider(){

                public AwsCredentials resolveCredentials() {
                    return AwsBasicCredentials.create((String)SecretManagerHelper.this.accessKey, (String)SecretManagerHelper.this.secretKey);
                }
            };
        }
        SecretsManagerClientBuilder secretsClientBuilder = null;
        secretsClientBuilder = credentialsProvider != null ? (SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)this.region))).credentialsProvider(credentialsProvider) : (SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)this.region));
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            ProxyConfiguration.Builder proxyConfig = ProxyConfiguration.builder().endpoint(new URI(String.format("%s://%s:%d", this.proxyProtocol, this.proxyHost, this.proxyPort)));
            if (this.proxyUser != null && !this.proxyUser.equals("")) {
                proxyConfig.username(this.proxyUser);
            }
            if (this.proxyPassword != null && !this.proxyPassword.equals("")) {
                proxyConfig.password(this.proxyPassword);
            }
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            return (SecretsManagerClient)((SecretsManagerClientBuilder)secretsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).build();
        }
        return (SecretsManagerClient)secretsClientBuilder.build();
    }
}

