/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import ai.digital.deploy.sql.model.LoginProvider;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.OpenIdConnectConfig$;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.NimbusJwtClientAuthenticationParametersConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.FunctionConverters$;
import scala.jdk.FunctionWrappers;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="oidc")
@EnableWebSecurity
@Configuration
@ComponentScan(value={"com.xebialabs.xldeploy.auth.oidc.config"})
@ScalaSignature(bytes="\u0006\u0005\rMr!B\u0012%\u0011\u0003\td!B\u001a%\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%\tA\u0010\u0005\u0007;\u0006\u0001\u000b\u0011B \u0007\tM\"\u0003A\u0018\u0005\u0006w\u0015!\ta\u001a\u0005\u0006S\u0016!\tA\u001b\u0005\u0006o\u0016!\t\u0001\u001f\u0005\u0007\u0003#)A\u0011\u0001=\t\u000f\u0005UQ\u0001\"\u0001\u0002\u0018!9\u00111F\u0003\u0005\u0002\u00055\u0002bBA&\u000b\u0011\u0005\u0011Q\n\u0005\b\u0003s*A\u0011AA>\u0011\u001d\tY)\u0002C\u0001\u0003\u001bCq!!+\u0006\t\u0003\tY\u000bC\u0004\u0002D\u0016!\t!!2\t\u000f\u0005mW\u0001\"\u0001\u0002^\"9\u0011q]\u0003\u0005\u0002\u0005%\bbBA\u0000\u000b\u0011\u0005!\u0011\u0001\u0005\n\u0005+)!\u0019!C\u0001\u0005/A\u0001B!\r\u0006A\u0003%!\u0011\u0004\u0005\b\u0005g)A\u0011\u0001B\u001b\u0011\u001d\u0011)%\u0002C\u0001\u0005\u000fBqA!\u0015\u0006\t\u0003\u0011\u0019\u0006C\u0004\u0003b\u0015!\tAa\u0019\t\u000f\t5T\u0001\"\u0003\u0003p!9!\u0011O\u0003\u0005\n\tM\u0004b\u0002BB\u000b\u0011%!Q\u0011\u0005\b\u0005++A\u0011\u0002BL\u0011\u001d\u00119+\u0002C\u0005\u0005SCqA!-\u0006\t\u0013\u0011\u0019\fC\u0004\u0003B\u0016!IAa1\t\u000f\tEW\u0001\"\u0003\u0003T\"9!1\\\u0003\u0005\u0002\tu\u0017aE(qK:LEmQ8o]\u0016\u001cGoQ8oM&<'BA\u0013'\u0003\u0011\u0019wN\u001c4\u000b\u0005\u001dB\u0013\u0001B8jI\u000eT!!\u000b\u0016\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u00111\u0006L\u0001\tq2$W\r\u001d7ps*\u0011QFL\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aL\u0001\u0004G>l7\u0001\u0001\t\u0003e\u0005i\u0011\u0001\n\u0002\u0014\u001fB,g.\u00133D_:tWm\u0019;D_:4\u0017nZ\n\u0003\u0003U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00012\u0003Ui\u0015iQ0B\u0019\u001e{%+\u0013+I\u001b~k\u0015\t\u0015)J\u001d\u001e+\u0012a\u0010\t\u0005\u0001\u001eS%L\u0004\u0002B\u000bB\u0011!iN\u0007\u0002\u0007*\u0011A\tM\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019;\u0014A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n\u0019Q*\u00199\u000b\u0005\u0019;\u0004CA&Y\u001b\u0005a%BA'O\u0003\rQwo\u001d\u0006\u0003\u001fB\u000bAA[8tK*\u0011\u0011KU\u0001\u0007_\u0006,H\u000f\u001b\u001a\u000b\u0005M#\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005U3\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003]\u000b1a\u001c:h\u0013\tIFJ\u0001\u0007NC\u000e\fEnZ8sSRDW\u000e\u0005\u0002A7&\u0011A,\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002-5\u000b5iX!M\u000f>\u0013\u0016\n\u0016%N?6\u000b\u0005\u000bU%O\u000f\u0002\u001a2!B\u001b`!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0003tY\u001a$$NC\u0001e\u0003!9'/\u001b>{Y\u0016$\u0017B\u00014b\u0005\u001daunZ4j]\u001e$\u0012\u0001\u001b\t\u0003e\u0015\t!b\\5eG\u000e{gNZ5h+\u0005Y\u0007C\u0001\u001am\u0013\tiGE\u0001\u0006PS\u0012\u001c7i\u001c8gS\u001eD#aB8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018AC1o]>$\u0018\r^5p]*\u0011A\u000fV\u0001\bG>tG/\u001a=u\u0013\t1\u0018O\u0001\u0003CK\u0006t\u0017!E8jI\u000edunZ5o!J|g/\u001b3feV\t\u0011\u0010E\u0002{\u0003\u0017i\u0011a\u001f\u0006\u0003yv\fQ!\\8eK2T!A`@\u0002\u0007M\fHN\u0003\u0003\u0002\u0002\u0005\r\u0011A\u00023fa2|\u0017P\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u00023jO&$\u0018\r\u001c\u0006\u0003\u0003\u0013\t!!Y5\n\u0007\u000551PA\u0007M_\u001eLg\u000e\u0015:pm&$WM\u001d\u0015\u0003\u0011=\f!\u0003\\8dC2dunZ5o!J|g/\u001b3fe\"\u0012\u0011b\\\u0001\u001dG2LWM\u001c;SK\u001eL7\u000f\u001e:bi&|gNU3q_NLGo\u001c:z+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0019I,w-[:ue\u0006$\u0018n\u001c8\u000b\u0007\u0005\r\u0002+\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003O\tiB\u0001\u0013J]6+Wn\u001c:z\u00072LWM\u001c;SK\u001eL7\u000f\u001e:bi&|gNU3q_NLGo\u001c:zQ\tQq.\u0001\u0011dY\u0006LWn\u001d+p\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:ji&,7\u000fU8mS\u000eLXCAA\u0018!\u0011\t\t$!\u0012\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tA![7qY*!\u0011\u0011HA\u001e\u0003\u0019\u0001x\u000e\\5ds*\u0019q%!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0004gN|'bAA\"Y\u0005A\u0001\u000f\\1uM>\u0014X.\u0003\u0003\u0002H\u0005M\"a\n#fM\u0006,H\u000e^\"mC&l7\u000fV8He\u0006tG/\u001a3BkRDwN]5uS\u0016\u001c\bk\u001c7jGfD#aC8\u0002E\r,8\u000f^8n\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8SKF,Xm\u001d;SKN|GN^3s)\u0011\ty%a\u0017\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'RA!!\u0016\u0002<\u0005\u0019q/\u001a2\n\t\u0005e\u00131\u000b\u0002#\u0007V\u001cHo\\7BkRDwN]5{CRLwN\u001c*fcV,7\u000f\u001e*fg>dg/\u001a:\t\u000f\u0005UA\u00021\u0001\u0002^A!\u00111DA0\u0013\u0011\t\t'!\b\u00039\rc\u0017.\u001a8u%\u0016<\u0017n\u001d;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\"\u001aA\"!\u001a\u0011\t\u0005\u001d\u00141O\u0007\u0003\u0003SR1A]A6\u0015\u0011\ti'a\u001c\u0002\u000f\u0019\f7\r^8ss*\u0019\u0011\u0011\u000f+\u0002\u000b\t,\u0017M\\:\n\t\u0005U\u0014\u0011\u000e\u0002\n\u0003V$xn^5sK\u0012D#\u0001D8\u0002/\u0005,H\u000f[8sSj,Gm\u00117jK:$8+\u001a:wS\u000e,G\u0003BA?\u0003\u000b\u0003B!a \u0002\u00026\u0011\u0011\u0011E\u0005\u0005\u0003\u0007\u000b\tCA\u0013J]6+Wn\u001c:z\u001f\u0006+H\u000f\u001b\u001aBkRDwN]5{K\u0012\u001cE.[3oiN+'O^5dK\"9\u0011QC\u0007A\u0002\u0005u\u0003fA\u0007\u0002f!\u0012Qb\\\u0001\u0012q2|\u0015\u000eZ2Vg\u0016\u00148+\u001a:wS\u000e,G\u0003BAH\u00037\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0005\u0003+\u000bY$A\u0004tKJ4\u0018nY3\n\t\u0005e\u00151\u0013\u0002\u001212{\u0015\u000eZ2Vg\u0016\u00148+\u001a:wS\u000e,\u0007bBA\u0016\u001d\u0001\u0007\u0011Q\u0014\t\u0005\u0003?\u000b\t+\u0004\u0002\u00028%!\u00111UA\u001c\u0005\u0001\u001aE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u00079\t)\u0007\u000b\u0002\u000f_\u0006Q\u0012-\u001e;i_JL'0\u001a3DY&,g\u000e\u001e*fa>\u001c\u0018\u000e^8ssR!\u0011QVA\\!\u0011\ty+a-\u000e\u0005\u0005E&\u0002BA+\u0003CIA!!.\u00022\n1\u0014)\u001e;iK:$\u0018nY1uK\u0012\u0004&/\u001b8dSB\fGnT!vi\"\u0014\u0014)\u001e;i_JL'0\u001a3DY&,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\"9\u0011\u0011P\bA\u0002\u0005e\u0006\u0003BA@\u0003wKA!!0\u0002\"\tir*Q;uQJ\nU\u000f\u001e5pe&TX\rZ\"mS\u0016tGoU3sm&\u001cW\rK\u0002\u0010\u0003KB#aD8\u0002+%$Gk\\6f]\u0012+7m\u001c3fe\u001a\u000b7\r^8ssV\u0011\u0011q\u0019\t\u0007\u0003\u0013\fy-a5\u000e\u0005\u0005-'bAAg!\u0006\u0019!n\u001e;\n\t\u0005E\u00171\u001a\u0002\u0012\u0015^$H)Z2pI\u0016\u0014h)Y2u_JL\b\u0003BA\u000e\u0003+LA!a6\u0002\u001e\t\u00112\t\\5f]R\u0014VmZ5tiJ\fG/[8oQ\t\u0001r.\u0001\u0006koR$UmY8eKJ,\"!a8\u0011\t\u0005%\u0017\u0011]\u0005\u0005\u0003G\fYM\u0001\u0006KoR$UmY8eKJD#!E8\u00025)<H/Q;uQ\u0016tG/[2bi&|gnQ8om\u0016\u0014H/\u001a:\u0016\u0005\u0005-\b\u0003BAw\u0003sl!!a<\u000b\u0007%\n\tP\u0003\u0003\u0002t\u0006U\u0018\u0001\u0003:fg>,(oY3\u000b\u0007\u0005]\b+\u0001\u0004tKJ4XM]\u0005\u0005\u0003w\fyO\u0001\u000eKoR\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cuN\u001c<feR,'\u000f\u000b\u0002\u0013_\u0006!\u0013-\u001e;i_JL'0\u0019;j_:\u001cu\u000eZ3U_.,gNU3ta>t7/Z\"mS\u0016tG\u000f\u0006\u0003\u0003\u0004\t=\u0001\u0003\u0002B\u0003\u0005\u0017i!Aa\u0002\u000b\t\t%\u0011\u0011E\u0001\tK:$\u0007o\\5oi&!!Q\u0002B\u0004\u0005-\"UMZ1vYR\fU\u000f\u001e5pe&T\u0018\r^5p]\u000e{G-\u001a+pW\u0016t'+Z:q_:\u001cXm\u00117jK:$\bbBA\u000b'\u0001\u0007\u0011Q\f\u0015\u0004'\u0005\u0015\u0004FA\np\u0003-Qwo\u001b*fg>dg/\u001a:\u0016\u0005\te\u0001c\u0002\u001c\u0003\u001c\u0005M'qD\u0005\u0004\u0005;9$!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011\tC!\f\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\t1A[<l\u0015\ry%\u0011\u0006\u0006\u0004\u0005Wq\u0013\u0001\u00038j[\n,8\u000fZ:\n\t\t=\"1\u0005\u0002\u0004\u0015^[\u0015\u0001\u00046xWJ+7o\u001c7wKJ\u0004\u0013aF8jI\u000edunZ5o\r\u0006LG.\u001e:f\u0011\u0006tG\r\\3s+\t\u00119\u0004\u0005\u0003\u0003:\t}RB\u0001B\u001e\u0015\rI#Q\b\u0006\u0004\u0003+\u0012\u0016\u0002\u0002B!\u0005w\u0011A$Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\rS1oI2,'\u000f\u000b\u0002\u0017_\u00061\u0002\u0010\u001c3M_\u001eLgNR1jYV\u0014X\rS1oI2,'/\u0006\u0002\u0003JA!!\u0011\bB&\u0013\u0011\u0011iEa\u000f\u0003KMKW\u000e\u001d7f+Jd\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007*\u00198eY\u0016\u0014\bFA\fp\u0003iy\u0007/\u001a8JI2{wm\\;u'V\u001c7-Z:t\u0011\u0006tG\r\\3s)\u0011\u0011)Fa\u0017\u0011\t\u0005E#qK\u0005\u0005\u00053\n\u0019F\u0001\rPS\u0012\u001cGj\\4pkR\u001cVoY2fgND\u0015M\u001c3mKJDq!!\u0006\u0019\u0001\u0004\ti\u0006K\u0002\u0019\u0003KB#\u0001G8\u0002A1|w-\u001b8Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001e:z!>Lg\u000e^\u000b\u0003\u0005K\u0002BA!\u000f\u0003h%!!\u0011\u000eB\u001e\u0005\u0001bunZ5o+Jd\u0017)\u001e;iK:$\u0018nY1uS>tWI\u001c;ssB{\u0017N\u001c;)\u0005ey\u0017AE2mS\u0016tGOU3hSN$(/\u0019;j_:,\"!a5\u00029\u001d,Go\u00117jK:$(+Z4jgR\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3feV\u0011!Q\u000f\t\u0005\u0005o\u0012iH\u0004\u0003\u0002\u001c\te\u0014\u0002\u0002B>\u0003;\t!c\u00117jK:$(+Z4jgR\u0014\u0018\r^5p]&!!q\u0010BA\u0005\u001d\u0011U/\u001b7eKJTAAa\u001f\u0002\u001e\u0005A2\r\\5f]RDE\u000f\u001e9SKF,Xm\u001d;GC\u000e$xN]=\u0016\u0005\t\u001d\u0005\u0003\u0002BE\u0005#k!Aa#\u000b\t\u0005\r\"Q\u0012\u0006\u0004\u0005\u001f#\u0016\u0001\u00025uiBLAAa%\u0003\f\nA2\t\\5f]RDE\u000f\u001e9SKF,Xm\u001d;GC\u000e$xN]=\u0002\u001f\u001d,GOS<t\u00032<wN]5uQ6$bA!'\u0003 \n\r\u0006cA&\u0003\u001c&\u0019!Q\u0014'\u0003\u0019);8/\u00117h_JLG\u000f[7\t\r\t\u0005V\u00041\u0001[\u00031Qwo]!mO>\u0014\u0018\u000e\u001e5n\u0011\u0019\u0011)+\ba\u00015\u0006a\u0001O]8qKJ$\u0018PT1nK\u0006yq-\u001a;NC\u000e\fEnZ8sSRDW\u000eF\u0003K\u0005W\u0013y\u000b\u0003\u0004\u0003.z\u0001\rAW\u0001\r[\u0006\u001c\u0017\t\\4pe&$\b.\u001c\u0005\u0007\u0005Ks\u0002\u0019\u0001.\u0002'\u001d,Go\u00117jK:$\u0018)\u001e;i\u001b\u0016$\bn\u001c3\u0016\u0005\tU\u0006\u0003\u0002B\\\u0005{k!A!/\u000b\u0007\tm\u0006+\u0001\u0003d_J,\u0017\u0002\u0002B`\u0005s\u0013!d\u00117jK:$\u0018)\u001e;iK:$\u0018nY1uS>tW*\u001a;i_\u0012\f!dZ3u\u0015^$x*Q;uQJ\"vn[3o-\u0006d\u0017\u000eZ1u_J,\"A!2\u0011\r\t]&q\u0019Bf\u0013\u0011\u0011IM!/\u0003)=\u000bU\u000f\u001e53)>\\WM\u001c,bY&$\u0017\r^8s!\u0011\tIM!4\n\t\t=\u00171\u001a\u0002\u0004\u0015^$\u0018!\u0007<bY&$\u0017\r^3PS\u0012\u001c7i\u001c8gS\u001e,(/\u0019;j_:$\"A!6\u0011\u0007Y\u00129.C\u0002\u0003Z^\u0012A!\u00168ji\u0006ir-\u001a;FeJ|'/T3tg\u0006<WMR8s!2\f7-\u001a5pY\u0012,'\u000fF\u0002[\u0005?DaA!9#\u0001\u0004Q\u0016a\u00039mC\u000e,\u0007n\u001c7eKJDs!\u0002Bs\u0005W\u0014i\u000fE\u0002q\u0005OL1A!;r\u00055\u0019u.\u001c9p]\u0016tGoU2b]\u0006)a/\u00197vK2\u0012!q^\u0011\u0003\u0005c\fqeY8n]a,'-[1mC\n\u001ch\u0006\u001f7eKBdw.\u001f\u0018bkRDgf\\5eG:\u001awN\u001c4jO\"\u001aQA!>\u0011\u0007A\u001490C\u0002\u0003zF\u0014QbQ8oM&<WO]1uS>t\u0007fA\u0003\u0003~B!!q`B\u0007\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\r\u0015\u0011!D2p]\u001aLw-\u001e:bi&|gN\u0003\u0003\u0002V\r\u001d!b\u0001:\u0004\n)\u001911\u0002*\u0002\r\r|gNZ5h\u0013\u0011\u0019ya!\u0001\u0003#\u0015s\u0017M\u00197f/\u0016\u00147+Z2ve&$\u0018\u0010K\u0006\u0006\u0007'\u00199c!\u000b\u00040\rE\u0002\u0003BB\u000b\u0007Gi!aa\u0006\u000b\t\re11D\u0001\nG>tG-\u001b;j_:TAa!\b\u0004 \u0005i\u0011-\u001e;pG>tg-[4ve\u0016T1a!\tU\u0003\u0011\u0011wn\u001c;\n\t\r\u00152q\u0003\u0002\u0016\u0007>tG-\u001b;j_:\fGn\u00148Qe>\u0004XM\u001d;z\u0003\u0011q\u0017-\\3-\u0005\r-\u0012EAB\u0017\u0003\u0011\"W\r\u001d7ps:\u001aXM\u001d<fe:\u001aXmY;sSRLh&Y;uQ:\u0002(o\u001c<jI\u0016\u0014\u0018a\u00035bm&twMV1mk\u0016\f\u0013a\n")
public class OpenIdConnectConfig
implements Logging {
    private final Function1<ClientRegistration, JWK> jwkResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static scala.collection.immutable.Map<MacAlgorithm, String> MAC_ALGORITHM_MAPPING() {
        return OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic(ConfigurationHolder$.MODULE$.get(), ConfigLoader$.MODULE$.loadWithDynamic$default$2()), ServerConfiguration.getInstance());
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    @Autowired
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        void var3_3;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "deploy.security.auth.providers.oidc.idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(x$1 -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoder jwtDecoder() {
        void var3_8;
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "deploy.security.auth.providers.oidc.access-token.jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'deploy.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(71).append("'").append(macAlgorithm.getName()).append("' is not supported. Ensure you have configured a valid HMAC Algorithm.").toString());
            }));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return var3_8;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        void var1_1;
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return var1_1;
    }

    @Bean
    @Autowired
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient(ClientRegistrationRepository clientRegistrationRepository) {
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient;
        block0: {
            ListBuffer messageConverter = new ListBuffer();
            messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
            messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
            RestTemplate restTemplate = new RestTemplate(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)messageConverter.toList()).asJava());
            restTemplate.setRequestFactory(this.clientHttpRequestFactory());
            restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
            authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
            authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
            ClientRegistration clientRegistration = clientRegistrationRepository.findByRegistrationId(this.oidcConfig().registrationId());
            ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod();
            ClientAuthenticationMethod clientAuthenticationMethod2 = ClientAuthenticationMethod.CLIENT_SECRET_JWT;
            if (clientAuthenticationMethod != null ? !clientAuthenticationMethod.equals(clientAuthenticationMethod2) : clientAuthenticationMethod2 != null) break block0;
            OAuth2AuthorizationCodeGrantRequestEntityConverter requestEntityConverter = new OAuth2AuthorizationCodeGrantRequestEntityConverter();
            requestEntityConverter.addParametersConverter((Converter)new NimbusJwtClientAuthenticationParametersConverter(FunctionWrappers.RichFunction1AsFunction$.MODULE$.asJavaFunction$extension(FunctionConverters$.MODULE$.enrichAsJavaFunction(this.jwkResolver()))));
            authorizationCodeTokenResponseClient.setRequestEntityConverter((Converter)requestEntityConverter);
        }
        return authorizationCodeTokenResponseClient;
    }

    public Function1<ClientRegistration, JWK> jwkResolver() {
        return this.jwkResolver;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (x$2, response, x$3) -> response.sendRedirect(this.oidcConfig().external_login());
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    @Autowired
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "/login");
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    private ClientRegistration clientRegistration() {
        BoxedUnit boxedUnit;
        ClientRegistration.Builder clientRegistrationBuilder = this.getClientRegistrationBuilder();
        ClientAuthenticationMethod authenticationMethod = this.getClientAuthMethod();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientAuthenticationMethod(authenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.oidcConfig().redirectUri()).userInfoUri("").scope(this.oidcConfig().scopes()).userNameAttributeName(this.oidcConfig().userNameClaimName());
        ClientAuthenticationMethod clientAuthenticationMethod = authenticationMethod;
        ClientAuthenticationMethod clientAuthenticationMethod2 = ClientAuthenticationMethod.NONE;
        if (clientAuthenticationMethod == null ? clientAuthenticationMethod2 != null : !clientAuthenticationMethod.equals(clientAuthenticationMethod2)) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().clientSecret()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientSecret"), (Object[])new Object[0]);
            boxedUnit = clientRegistrationBuilder.clientSecret(this.oidcConfig().clientSecret());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        Object object2 = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        Object object3 = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        ClientRegistration clientRegistration = clientRegistrationBuilder.build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        Object object4 = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        ClientAuthenticationMethod clientAuthenticationMethod3 = authenticationMethod;
        ClientAuthenticationMethod clientAuthenticationMethod4 = ClientAuthenticationMethod.CLIENT_SECRET_JWT;
        Object object5 = !(clientAuthenticationMethod3 != null ? !clientAuthenticationMethod3.equals(clientAuthenticationMethod4) : clientAuthenticationMethod4 != null) ? updatedConfigurationMetadata.put("clientAuthJWSAlg", (String)this.getMacAlgorithm(this.oidcConfig().clientAuthJWSAlg(), "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg")) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException(new StringBuilder(148).append("Whitespace characters in issuer url [").append(this.oidcConfig().issuer()).append("] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.").toString());
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Unable to resolve Configuration with the provided Issuer of [").append(this.oidcConfig().issuer()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable)() -> re.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private ClientHttpRequestFactory clientHttpRequestFactory() {
        void var1_1;
        block0: {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return var1_1;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        scala.collection.immutable.Map jwsAlgorithms = (scala.collection.immutable.Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(77).append(propertyName).append(" value [").append(jwsAlgorithm).append("] is not supported. Ensure you have configured a valid JWS Algorithm.").toString());
        });
    }

    private MacAlgorithm getMacAlgorithm(String macAlgorithm, String propertyName) {
        scala.collection.immutable.Map macAlgorithms = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (MacAlgorithm)macAlgorithms.getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(78).append(propertyName).append(" value [").append(macAlgorithm).append("] is not supported. Ensure you have configured a valid HMAC Algorithm.").toString());
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        scala.collection.immutable.Map clientAuthMethods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_POST), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_jwt"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"private_key_jwt"), (Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"none"), (Object)ClientAuthenticationMethod.NONE)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(108).append("clientAuthMethod value [").append(this.oidcConfig().clientAuthMethod()).append(" is not supported. Ensure you have configured a valid client authentication method.]").toString());
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    public String getErrorMessageForPlaceholder(String placeholder) {
        return new StringBuilder(41).append("No configuration setting found for key '").append(placeholder).append("'").toString();
    }

    private static final JWK getJwk$1(ClientRegistration clientRegistration) {
        OctetSequenceKey octetSequenceKey;
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            JwsAlgorithm jwsAlgorithm = (JwsAlgorithm)clientRegistration.getProviderDetails().getConfigurationMetadata().get("clientAuthJWSAlg");
            JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
            if (!(jwsAlgorithm2 instanceof MacAlgorithm)) {
                throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
            }
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            SecretKeySpec secretKey = new SecretKeySpec(clientRegistration.getClientSecret().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(71).append("'").append(macAlgorithm.getName()).append("' is not supported. Ensure you have configured a valid HMAC Algorithm.").toString());
            }));
            OctetSequenceKey octetSequenceKey2 = new OctetSequenceKey.Builder((SecretKey)secretKey).algorithm(new Algorithm(macAlgorithm.getName())).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).build();
            octetSequenceKey = octetSequenceKey2;
        } else {
            octetSequenceKey = null;
        }
        return octetSequenceKey;
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
        this.jwkResolver = (Function1 & Serializable)clientRegistration -> OpenIdConnectConfig.getJwk$1(clientRegistration);
    }
}

