/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u001f?\u0001-C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t5\u0002\u0011\t\u0011)A\u00057\")\u0011\r\u0001C\u0001E\"9q\r\u0001b\u0001\n\u0003A\u0007B\u0002;\u0001A\u0003%\u0011\u000eC\u0004v\u0001\t\u0007I\u0011\u00015\t\rY\u0004\u0001\u0015!\u0003j\u0011\u001d9\bA1A\u0005\u0002!Da\u0001\u001f\u0001!\u0002\u0013I\u0007bB=\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007u\u0002\u0001\u000b\u0011B5\t\u000fm\u0004!\u0019!C\u0001Q\"1A\u0010\u0001Q\u0001\n%Dq! \u0001C\u0002\u0013\u0005\u0001\u000e\u0003\u0004\u007f\u0001\u0001\u0006I!\u001b\u0005\b\u007f\u0002\u0011\r\u0011\"\u0001i\u0011\u001d\t\t\u0001\u0001Q\u0001\n%D\u0001\"a\u0001\u0001\u0005\u0004%\t\u0001\u001b\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003j\u0011!\t9\u0001\u0001b\u0001\n\u0003A\u0007bBA\u0005\u0001\u0001\u0006I!\u001b\u0005\t\u0003\u0017\u0001!\u0019!C\u0001Q\"9\u0011Q\u0002\u0001!\u0002\u0013I\u0007\u0002CA\b\u0001\t\u0007I\u0011\u00015\t\u000f\u0005E\u0001\u0001)A\u0005S\"A\u00111\u0003\u0001C\u0002\u0013\u0005\u0001\u000eC\u0004\u0002\u0016\u0001\u0001\u000b\u0011B5\t\u0011\u0005]\u0001A1A\u0005\u0002!Dq!!\u0007\u0001A\u0003%\u0011\u000e\u0003\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0001i\u0011\u001d\ti\u0002\u0001Q\u0001\n%D\u0001\"a\b\u0001\u0005\u0004%\t\u0001\u001b\u0005\b\u0003C\u0001\u0001\u0015!\u0003j\u0011!\t\u0019\u0003\u0001b\u0001\n\u0003A\u0007bBA\u0013\u0001\u0001\u0006I!\u001b\u0005\t\u0003O\u0001!\u0019!C\u0001Q\"9\u0011\u0011\u0006\u0001!\u0002\u0013I\u0007\u0002CA\u0016\u0001\t\u0007I\u0011\u00015\t\u000f\u00055\u0002\u0001)A\u0005S\"A\u0011q\u0006\u0001C\u0002\u0013\u0005\u0001\u000eC\u0004\u00022\u0001\u0001\u000b\u0011B5\t\u0011\u0005M\u0002A1A\u0005\u0002!Dq!!\u000e\u0001A\u0003%\u0011\u000e\u0003\u0005\u00028\u0001\u0011\r\u0011\"\u0001i\u0011\u001d\tI\u0004\u0001Q\u0001\n%D\u0001\"a\u000f\u0001\u0005\u0004%\t\u0001\u001b\u0005\b\u0003{\u0001\u0001\u0015!\u0003j\u0011!\ty\u0004\u0001b\u0001\n\u0003A\u0007bBA!\u0001\u0001\u0006I!\u001b\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003\u000bB\u0011\"a\u0016\u0001\u0001\u0004%\t!!\u0017\t\u0011\u0005\u0015\u0004\u0001)Q\u0005\u0003\u000fB\u0011\"a\u001a\u0001\u0001\u0004%\t!!\u001b\t\u0013\u0005]\u0004\u00011A\u0005\u0002\u0005e\u0004\u0002CA?\u0001\u0001\u0006K!a\u001b\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\tI\u000b\u0001C\u0005\u0003W\u0013!bT5eG\u000e{gNZ5h\u0015\ty\u0004)\u0001\u0003d_:4'BA!C\u0003\u0011y\u0017\u000eZ2\u000b\u0005\r#\u0015AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003\u000b\u001a\u000b\u0001\u0002\u001f7eKBdw.\u001f\u0006\u0003\u000f\"\u000b\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\u000b1aY8n\u0007\u0001\u0019\"\u0001\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019wN\u001c4jOB\u0011A\u000bW\u0007\u0002+*\u0011!K\u0016\u0006\u0003/\"\u000b\u0001\u0002^=qKN\fg-Z\u0005\u00033V\u0013aaQ8oM&<\u0017aE:feZ,'oQ8oM&<WO]1uS>t\u0007C\u0001/`\u001b\u0005i&B\u00010G\u0003!!W\r\u001d7ps&$\u0018B\u00011^\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u00191-\u001a4\u0011\u0005\u0011\u0004Q\"\u0001 \t\u000bI\u001b\u0001\u0019A*\t\u000bi\u001b\u0001\u0019A.\u0002\u001dI,w-[:ue\u0006$\u0018n\u001c8JIV\t\u0011\u000e\u0005\u0002kc:\u00111n\u001c\t\u0003Y:k\u0011!\u001c\u0006\u0003]*\u000ba\u0001\u0010:p_Rt\u0014B\u00019O\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005At\u0015a\u0004:fO&\u001cHO]1uS>t\u0017\n\u001a\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0019\rd\u0017.\u001a8u'\u0016\u001c'/\u001a;\u0002\u001b\rd\u0017.\u001a8u'\u0016\u001c'/\u001a;!\u0003A\u0019G.[3oi\u0006+H\u000f['fi\"|G-A\tdY&,g\u000e^!vi\"lU\r\u001e5pI\u0002\n\u0001c\u00197jK:$\u0018)\u001e;i\u0015^\u001b\u0016\t\\4\u0002#\rd\u0017.\u001a8u\u0003V$\bNS,T\u00032<\u0007%\u0001\u0004jgN,XM]\u0001\bSN\u001cX/\u001a:!\u0003!Qwo[:`kJL\u0017!\u00036xWN|VO]5!\u00039\t7mY3tgR{7.\u001a8Ve&\fq\"Y2dKN\u001cHk\\6f]V\u0013\u0018\u000eI\u0001\u0015kN,'/Q;uQ>\u0014\u0018N_1uS>tWK]5\u0002+U\u001cXM]!vi\"|'/\u001b>bi&|g.\u0016:jA\u0005IAn\\4pkR,&/[\u0001\u000bY><w.\u001e;Ve&\u0004\u0013a\u0003:fI&\u0014Xm\u0019;Ve&\fAB]3eSJ,7\r^+sS\u0002\nQ\u0003]8ti2{wm\\;u%\u0016$\u0017N]3diV\u0013\u0018.\u0001\fq_N$Hj\\4pkR\u0014V\rZ5sK\u000e$XK]5!\u00039\u0011x\u000e\\3t\u00072\f\u0017.\u001c(b[\u0016\fqB]8mKN\u001cE.Y5n\u001d\u0006lW\rI\u0001\u0012kN,'OT1nK\u000ec\u0017-[7OC6,\u0017AE;tKJt\u0015-\\3DY\u0006LWNT1nK\u0002\nQ\"\u001b3U_.,gNS,T\u00032<\u0017AD5e)>\\WM\u001c&X'\u0006cw\rI\u0001\u0012C\u000e\u001cWm]:U_.,g.S:tk\u0016\u0014\u0018AE1dG\u0016\u001c8\u000fV8lK:L5o];fe\u0002\n1#Y2dKN\u001cHk\\6f]\u0006+H-[3oG\u0016\fA#Y2dKN\u001cHk\\6f]\u0006+H-[3oG\u0016\u0004\u0013!E1dG\u0016\u001c8\u000fV8lK:\\U-_+sS\u0006\u0011\u0012mY2fgN$vn[3o\u0017\u0016LXK]5!\u0003E\t7mY3tgR{7.\u001a8K/N\u000bEnZ\u0001\u0013C\u000e\u001cWm]:U_.,gNS,T\u00032<\u0007%\u0001\u000bbG\u000e,7o\u001d+pW\u0016t7+Z2sKR\\U-_\u0001\u0016C\u000e\u001cWm]:U_.,gnU3de\u0016$8*Z=!\u00039)\u0007\u0010^3s]\u0006dw\f\\8hS:\fq\"\u001a=uKJt\u0017\r\\0m_\u001eLg\u000eI\u0001\u0017Y><\u0017N\\'fi\"|G\rR3tGJL\u0007\u000f^5p]\u00069Bn\\4j]6+G\u000f[8e\t\u0016\u001c8M]5qi&|g\u000eI\u0001\naJ|\u00070\u001f%pgR\f!\u0002\u001d:pqfDun\u001d;!\u0003%\u0001(o\u001c=z!>\u0014H/\u0006\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001\u00027b]\u001eT!!!\u0015\u0002\t)\fg/Y\u0005\u0005\u0003+\nYEA\u0004J]R,w-\u001a:\u0002\u001bA\u0014x\u000e_=Q_J$x\fJ3r)\u0011\tY&!\u0019\u0011\u00075\u000bi&C\u0002\u0002`9\u0013A!\u00168ji\"I\u00111M\u001a\u0002\u0002\u0003\u0007\u0011qI\u0001\u0004q\u0012\n\u0014A\u00039s_bL\bk\u001c:uA\u000511oY8qKN,\"!a\u001b\u0011\u000b\u00055\u00141O5\u000e\u0005\u0005=$\u0002BA9\u0003\u001f\nA!\u001e;jY&!\u0011QOA8\u0005\u0011a\u0015n\u001d;\u0002\u0015M\u001cw\u000e]3t?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0005m\u0004\"CA2m\u0005\u0005\t\u0019AA6\u0003\u001d\u00198m\u001c9fg\u0002\n\u0011cZ3u'R\u0014\u0018N\\4Qe>\u0004XM\u001d;z)\u001dI\u00171QAC\u0003\u0013CQA\u0015\u001dA\u0002MCa!a\"9\u0001\u0004I\u0017\u0001\u00028b[\u0016Da!a#9\u0001\u0004I\u0017\u0001\u00043fM\u0006,H\u000e\u001e,bYV,\u0017AD4fi&sG\u000f\u0015:pa\u0016\u0014H/\u001f\u000b\t\u0003\u000f\n\t*a%\u0002\u0016\")!+\u000fa\u0001'\"1\u0011qQ\u001dA\u0002%Dq!a#:\u0001\u0004\t9%A\nhKR,enY8eK\u0012,&/[*ue&tw\rF\u0002j\u00037Ca!!(;\u0001\u0004I\u0017aA;sS\u0006\u0019r-\u001a;EK\u000e|G-\u001a3Ve&\u001cFO]5oOR!\u00111UAT!\u0011\tI%!*\n\u0007I\fY\u0005\u0003\u0004\u0002\u001en\u0002\r![\u0001\u0016O\u0016$8\u000b\u001e:j]\u001ed\u0015n\u001d;Qe>\u0004XM\u001d;z)!\tY'!,\u00020\u0006E\u0006\"\u0002*=\u0001\u0004\u0019\u0006BBADy\u0001\u0007\u0011\u000eC\u0004\u0002\fr\u0002\r!a\u001b")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String clientAuthJWSAlg;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;
    private List<String> scopes;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String clientAuthJWSAlg() {
        return this.clientAuthJWSAlg;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public void scopes_$eq(List<String> x$1) {
        this.scopes = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    private List<String> getStringListProperty(Config config, String name, List<String> defaultValue) {
        List<String> list;
        try {
            list = config.getStringList(name);
        }
        catch (ConfigException.Missing missing) {
            list = defaultValue;
        }
        return list;
    }

    public OidcConfig(Config config, ServerConfiguration serverConfiguration) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("deploy.security.auth.providers.oidc.clientId");
        this.clientSecret = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientSecret", "");
        this.clientAuthMethod = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.clientAuthJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg", MacAlgorithm.HS256.getName());
        this.issuer = this.getDecodedUriString(config.getString("deploy.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.redirectUri", new StringBuilder(20).append(serverConfiguration.getServerUrl()).append("login/external-login").toString()));
        this.postLogoutRedirectUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("deploy.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("deploy.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenIssuer = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "deploy.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "deploy.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "deploy.security.auth.providers.oidc.proxyPort", null);
        this.scopes = this.getStringListProperty(config, "deploy.security.auth.providers.oidc.scopes", (List<String>)new ArrayList<String>(null){
            {
                this.add("openid");
            }
        });
    }
}

