/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\u001c9\u0001\u0015C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\")1\f\u0001C\u00019\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0007B\u00028\u0001A\u0003%1\rC\u0004p\u0001\t\u0007I\u0011\u00012\t\rA\u0004\u0001\u0015!\u0003d\u0011\u001d\t\bA1A\u0005\u0002\tDaA\u001d\u0001!\u0002\u0013\u0019\u0007bB:\u0001\u0005\u0004%\tA\u0019\u0005\u0007i\u0002\u0001\u000b\u0011B2\t\u000fU\u0004!\u0019!C\u0001E\"1a\u000f\u0001Q\u0001\n\rDqa\u001e\u0001C\u0002\u0013\u0005!\r\u0003\u0004y\u0001\u0001\u0006Ia\u0019\u0005\bs\u0002\u0011\r\u0011\"\u0001c\u0011\u0019Q\b\u0001)A\u0005G\"91\u0010\u0001b\u0001\n\u0003\u0011\u0007B\u0002?\u0001A\u0003%1\rC\u0004~\u0001\t\u0007I\u0011\u00012\t\ry\u0004\u0001\u0015!\u0003d\u0011\u001dy\bA1A\u0005\u0002\tDq!!\u0001\u0001A\u0003%1\r\u0003\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0001c\u0011\u001d\t)\u0001\u0001Q\u0001\n\rD\u0001\"a\u0002\u0001\u0005\u0004%\tA\u0019\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003d\u0011!\tY\u0001\u0001b\u0001\n\u0003\u0011\u0007bBA\u0007\u0001\u0001\u0006Ia\u0019\u0005\t\u0003\u001f\u0001!\u0019!C\u0001E\"9\u0011\u0011\u0003\u0001!\u0002\u0013\u0019\u0007\u0002CA\n\u0001\t\u0007I\u0011\u00012\t\u000f\u0005U\u0001\u0001)A\u0005G\"A\u0011q\u0003\u0001C\u0002\u0013\u0005!\rC\u0004\u0002\u001a\u0001\u0001\u000b\u0011B2\t\u0011\u0005m\u0001A1A\u0005\u0002\tDq!!\b\u0001A\u0003%1\r\u0003\u0005\u0002 \u0001\u0011\r\u0011\"\u0001c\u0011\u001d\t\t\u0003\u0001Q\u0001\n\rD\u0001\"a\t\u0001\u0005\u0004%\tA\u0019\u0005\b\u0003K\u0001\u0001\u0015!\u0003d\u0011!\t9\u0003\u0001b\u0001\n\u0003\u0011\u0007bBA\u0015\u0001\u0001\u0006Ia\u0019\u0005\t\u0003W\u0001!\u0019!C\u0001E\"9\u0011Q\u0006\u0001!\u0002\u0013\u0019\u0007\u0002CA\u0018\u0001\t\u0007I\u0011\u00012\t\u000f\u0005E\u0002\u0001)A\u0005G\"I\u00111\u0007\u0001A\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u000f\u0002\u0001\u0019!C\u0001\u0003\u0013B\u0001\"!\u0016\u0001A\u0003&\u0011q\u0007\u0005\b\u0003/\u0002A\u0011BA-\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002x\u0001!I!!\u001f\u0003\u0015=KGmY\"p]\u001aLwM\u0003\u0002:u\u0005!1m\u001c8g\u0015\tYD(\u0001\u0003pS\u0012\u001c'BA\u001f?\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!a\u0010!\u0002\u0011adG-\u001a9m_fT!!\u0011\"\u0002\u0013a,'-[1mC\n\u001c(\"A\"\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u00011\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g-\u0001\u0004d_:4\u0017n\u001a\t\u0003\u001dJk\u0011a\u0014\u0006\u0003\u0019BS!!\u0015\"\u0002\u0011QL\b/Z:bM\u0016L!aU(\u0003\r\r{gNZ5h\u0003M\u0019XM\u001d<fe\u000e{gNZ5hkJ\fG/[8o!\t1\u0016,D\u0001X\u0015\tA\u0006)\u0001\u0005eKBdw._5u\u0013\tQvKA\nTKJ4XM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004;~\u0003\u0007C\u00010\u0001\u001b\u0005A\u0004\"\u0002'\u0004\u0001\u0004i\u0005\"\u0002+\u0004\u0001\u0004)\u0016A\u0004:fO&\u001cHO]1uS>t\u0017\nZ\u000b\u0002GB\u0011Am\u001b\b\u0003K&\u0004\"A\u001a%\u000e\u0003\u001dT!\u0001\u001b#\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0007*\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016I\u0003=\u0011XmZ5tiJ\fG/[8o\u0013\u0012\u0004\u0013\u0001C2mS\u0016tG/\u00133\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001D2mS\u0016tGoU3de\u0016$\u0018!D2mS\u0016tGoU3de\u0016$\b%\u0001\tdY&,g\u000e^!vi\"lU\r\u001e5pI\u0006\t2\r\\5f]R\fU\u000f\u001e5NKRDw\u000e\u001a\u0011\u0002\r%\u001c8/^3s\u0003\u001dI7o];fe\u0002\n\u0001B[<lg~+(/[\u0001\nU^\\7oX;sS\u0002\na\"Y2dKN\u001cHk\\6f]V\u0013\u0018.A\bbG\u000e,7o\u001d+pW\u0016tWK]5!\u0003Q)8/\u001a:BkRDwN]5{CRLwN\\+sS\u0006)Ro]3s\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Ve&\u0004\u0013!\u00037pO>,H/\u0016:j\u0003)awnZ8viV\u0013\u0018\u000eI\u0001\fe\u0016$\u0017N]3diV\u0013\u0018.\u0001\u0007sK\u0012L'/Z2u+JL\u0007%A\u000bq_N$Hj\\4pkR\u0014V\rZ5sK\u000e$XK]5\u0002-A|7\u000f\u001e'pO>,HOU3eSJ,7\r^+sS\u0002\naB]8mKN\u001cE.Y5n\u001d\u0006lW-A\bs_2,7o\u00117bS6t\u0015-\\3!\u0003E)8/\u001a:OC6,7\t\\1j[:\u000bW.Z\u0001\u0013kN,'OT1nK\u000ec\u0017-[7OC6,\u0007%A\u0007jIR{7.\u001a8K/N\u000bEnZ\u0001\u000fS\u0012$vn[3o\u0015^\u001b\u0016\t\\4!\u0003E\t7mY3tgR{7.\u001a8JgN,XM]\u0001\u0013C\u000e\u001cWm]:U_.,g.S:tk\u0016\u0014\b%A\nbG\u000e,7o\u001d+pW\u0016t\u0017)\u001e3jK:\u001cW-\u0001\u000bbG\u000e,7o\u001d+pW\u0016t\u0017)\u001e3jK:\u001cW\rI\u0001\u0012C\u000e\u001cWm]:U_.,gnS3z+JL\u0017AE1dG\u0016\u001c8\u000fV8lK:\\U-_+sS\u0002\n\u0011#Y2dKN\u001cHk\\6f]*;6+\u00117h\u0003I\t7mY3tgR{7.\u001a8K/N\u000bEn\u001a\u0011\u0002)\u0005\u001c7-Z:t)>\\WM\\*fGJ,GoS3z\u0003U\t7mY3tgR{7.\u001a8TK\u000e\u0014X\r^&fs\u0002\na\"\u001a=uKJt\u0017\r\\0m_\u001eLg.A\bfqR,'O\\1m?2|w-\u001b8!\u0003YawnZ5o\u001b\u0016$\bn\u001c3EKN\u001c'/\u001b9uS>t\u0017a\u00067pO&tW*\u001a;i_\u0012$Um]2sSB$\u0018n\u001c8!\u0003%\u0001(o\u001c=z\u0011>\u001cH/\u0001\u0006qe>D\u0018\u0010S8ti\u0002\n\u0011\u0002\u001d:pqf\u0004vN\u001d;\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\u0011\t)%a\u000f\u0003\u000f%sG/Z4fe\u0006i\u0001O]8ysB{'\u000f^0%KF$B!a\u0013\u0002RA\u0019q)!\u0014\n\u0007\u0005=\u0003J\u0001\u0003V]&$\b\"CA*c\u0005\u0005\t\u0019AA\u001c\u0003\rAH%M\u0001\u000baJ|\u00070\u001f)peR\u0004\u0013!E4fiN#(/\u001b8h!J|\u0007/\u001a:usR91-a\u0017\u0002^\u0005\u0005\u0004\"\u0002'4\u0001\u0004i\u0005BBA0g\u0001\u00071-\u0001\u0003oC6,\u0007BBA2g\u0001\u00071-\u0001\u0007eK\u001a\fW\u000f\u001c;WC2,X-\u0001\bhKRLe\u000e\u001e)s_B,'\u000f^=\u0015\u0011\u0005]\u0012\u0011NA6\u0003[BQ\u0001\u0014\u001bA\u00025Ca!a\u00185\u0001\u0004\u0019\u0007bBA2i\u0001\u0007\u0011qG\u0001\u0014O\u0016$XI\\2pI\u0016$WK]5TiJLgn\u001a\u000b\u0004G\u0006M\u0004BBA;k\u0001\u00071-A\u0002ve&\f1cZ3u\t\u0016\u001cw\u000eZ3e+JL7\u000b\u001e:j]\u001e$B!a\u001f\u0002\u0000A!\u0011\u0011HA?\u0013\ra\u00171\b\u0005\u0007\u0003k2\u0004\u0019A2")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    public OidcConfig(Config config, ServerConfiguration serverConfiguration) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("deploy.security.auth.providers.oidc.clientId");
        this.clientSecret = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientSecret", "");
        this.clientAuthMethod = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.issuer = this.getDecodedUriString(config.getString("deploy.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.redirectUri", new StringBuilder(20).append(serverConfiguration.getServerUrl()).append("login/external-login").toString()));
        this.postLogoutRedirectUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("deploy.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("deploy.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenIssuer = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "deploy.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "deploy.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "deploy.security.auth.providers.oidc.proxyPort", null);
    }
}

