/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001\u0002\u001e<\u0001!C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0011\u0019I\u0007\u0001)A\u0005=\"9!\u000e\u0001b\u0001\n\u0003i\u0006BB6\u0001A\u0003%a\fC\u0004m\u0001\t\u0007I\u0011A/\t\r5\u0004\u0001\u0015!\u0003_\u0011\u001dq\u0007A1A\u0005\u0002uCaa\u001c\u0001!\u0002\u0013q\u0006b\u00029\u0001\u0005\u0004%\t!\u0018\u0005\u0007c\u0002\u0001\u000b\u0011\u00020\t\u000fI\u0004!\u0019!C\u0001;\"11\u000f\u0001Q\u0001\nyCq\u0001\u001e\u0001C\u0002\u0013\u0005Q\f\u0003\u0004v\u0001\u0001\u0006IA\u0018\u0005\bm\u0002\u0011\r\u0011\"\u0001^\u0011\u00199\b\u0001)A\u0005=\"9\u0001\u0010\u0001b\u0001\n\u0003i\u0006BB=\u0001A\u0003%a\fC\u0004{\u0001\t\u0007I\u0011A/\t\rm\u0004\u0001\u0015!\u0003_\u0011\u001da\bA1A\u0005\u0002uCa! \u0001!\u0002\u0013q\u0006b\u0002@\u0001\u0005\u0004%\t!\u0018\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u00020\t\u0011\u0005\u0005\u0001A1A\u0005\u0002uCq!a\u0001\u0001A\u0003%a\f\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001^\u0011\u001d\t9\u0001\u0001Q\u0001\nyC\u0001\"!\u0003\u0001\u0005\u0004%\t!\u0018\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003_\u0011!\ti\u0001\u0001b\u0001\n\u0003i\u0006bBA\b\u0001\u0001\u0006IA\u0018\u0005\t\u0003#\u0001!\u0019!C\u0001;\"9\u00111\u0003\u0001!\u0002\u0013q\u0006\u0002CA\u000b\u0001\t\u0007I\u0011A/\t\u000f\u0005]\u0001\u0001)A\u0005=\"A\u0011\u0011\u0004\u0001C\u0002\u0013\u0005Q\fC\u0004\u0002\u001c\u0001\u0001\u000b\u0011\u00020\t\u0011\u0005u\u0001A1A\u0005\u0002uCq!a\b\u0001A\u0003%a\f\u0003\u0005\u0002\"\u0001\u0011\r\u0011\"\u0001^\u0011\u001d\t\u0019\u0003\u0001Q\u0001\nyC\u0001\"!\n\u0001\u0005\u0004%\t!\u0018\u0005\b\u0003O\u0001\u0001\u0015!\u0003_\u0011%\tI\u0003\u0001a\u0001\n\u0003\tY\u0003C\u0005\u0002>\u0001\u0001\r\u0011\"\u0001\u0002@!A\u00111\n\u0001!B\u0013\ti\u0003C\u0005\u0002N\u0001\u0001\r\u0011\"\u0001\u0002P!I\u0011Q\f\u0001A\u0002\u0013\u0005\u0011q\f\u0005\t\u0003G\u0002\u0001\u0015)\u0003\u0002R!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!a$\u0001\t\u0013\t\tJ\u0001\u0006PS\u0012\u001c7i\u001c8gS\u001eT!\u0001P\u001f\u0002\t\r|gN\u001a\u0006\u0003}}\nAa\\5eG*\u0011\u0001)Q\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\t\u00115)\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0015\t!U)A\u0005yK\nL\u0017\r\\1cg*\ta)A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0013B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\faaY8oM&<\u0007CA)V\u001b\u0005\u0011&BA(T\u0015\t!V)\u0001\u0005usB,7/\u00194f\u0013\t1&K\u0001\u0004D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005e[\u0006C\u0001.\u0001\u001b\u0005Y\u0004\"B(\u0003\u0001\u0004\u0001\u0016A\u0004:fO&\u001cHO]1uS>t\u0017\nZ\u000b\u0002=B\u0011qL\u001a\b\u0003A\u0012\u0004\"!Y&\u000e\u0003\tT!aY$\u0002\rq\u0012xn\u001c;?\u0013\t)7*\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3L\u0003=\u0011XmZ5tiJ\fG/[8o\u0013\u0012\u0004\u0013\u0001C2mS\u0016tG/\u00133\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001D2mS\u0016tGoU3de\u0016$\u0018!D2mS\u0016tGoU3de\u0016$\b%\u0001\tdY&,g\u000e^!vi\"lU\r\u001e5pI\u0006\t2\r\\5f]R\fU\u000f\u001e5NKRDw\u000e\u001a\u0011\u0002\r%\u001c8/^3s\u0003\u001dI7o];fe\u0002\n\u0001B[<lg~+(/[\u0001\nU^\\7oX;sS\u0002\na\"Y2dKN\u001cHk\\6f]V\u0013\u0018.A\bbG\u000e,7o\u001d+pW\u0016tWK]5!\u0003Q)8/\u001a:BkRDwN]5{CRLwN\\+sS\u0006)Ro]3s\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Ve&\u0004\u0013!\u00037pO>,H/\u0016:j\u0003)awnZ8viV\u0013\u0018\u000eI\u0001\fe\u0016$\u0017N]3diV\u0013\u0018.\u0001\u0007sK\u0012L'/Z2u+JL\u0007%A\u000bq_N$Hj\\4pkR\u0014V\rZ5sK\u000e$XK]5\u0002-A|7\u000f\u001e'pO>,HOU3eSJ,7\r^+sS\u0002\naB]8mKN\u001cE.Y5n\u001d\u0006lW-A\bs_2,7o\u00117bS6t\u0015-\\3!\u0003E)8/\u001a:OC6,7\t\\1j[:\u000bW.Z\u0001\u0013kN,'OT1nK\u000ec\u0017-[7OC6,\u0007%A\u0007jIR{7.\u001a8K/N\u000bEnZ\u0001\u000fS\u0012$vn[3o\u0015^\u001b\u0016\t\\4!\u0003E\t7mY3tgR{7.\u001a8JgN,XM]\u0001\u0013C\u000e\u001cWm]:U_.,g.S:tk\u0016\u0014\b%A\nbG\u000e,7o\u001d+pW\u0016t\u0017)\u001e3jK:\u001cW-\u0001\u000bbG\u000e,7o\u001d+pW\u0016t\u0017)\u001e3jK:\u001cW\rI\u0001\u0012C\u000e\u001cWm]:U_.,gnS3z+JL\u0017AE1dG\u0016\u001c8\u000fV8lK:\\U-_+sS\u0002\n\u0011#Y2dKN\u001cHk\\6f]*;6+\u00117h\u0003I\t7mY3tgR{7.\u001a8K/N\u000bEn\u001a\u0011\u0002)\u0005\u001c7-Z:t)>\\WM\\*fGJ,GoS3z\u0003U\t7mY3tgR{7.\u001a8TK\u000e\u0014X\r^&fs\u0002\na\"\u001a=uKJt\u0017\r\\0m_\u001eLg.A\bfqR,'O\\1m?2|w-\u001b8!\u0003YawnZ5o\u001b\u0016$\bn\u001c3EKN\u001c'/\u001b9uS>t\u0017a\u00067pO&tW*\u001a;i_\u0012$Um]2sSB$\u0018n\u001c8!\u0003%\u0001(o\u001c=z\u0011>\u001cH/\u0001\u0006qe>D\u0018\u0010S8ti\u0002\n\u0011\u0002\u001d:pqf\u0004vN\u001d;\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u0005Y\u0006twM\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\u0011\tY$!\r\u0003\u000f%sG/Z4fe\u0006i\u0001O]8ysB{'\u000f^0%KF$B!!\u0011\u0002HA\u0019!*a\u0011\n\u0007\u0005\u00153J\u0001\u0003V]&$\b\"CA%a\u0005\u0005\t\u0019AA\u0017\u0003\rAH%M\u0001\u000baJ|\u00070\u001f)peR\u0004\u0013AB:d_B,7/\u0006\u0002\u0002RA)\u00111KA-=6\u0011\u0011Q\u000b\u0006\u0005\u0003/\n)$\u0001\u0003vi&d\u0017\u0002BA.\u0003+\u0012A\u0001T5ti\u0006Q1oY8qKN|F%Z9\u0015\t\u0005\u0005\u0013\u0011\r\u0005\n\u0003\u0013\u001a\u0014\u0011!a\u0001\u0003#\nqa]2pa\u0016\u001c\b%A\thKR\u001cFO]5oOB\u0013x\u000e]3sif$rAXA5\u0003W\ny\u0007C\u0003Pk\u0001\u0007\u0001\u000b\u0003\u0004\u0002nU\u0002\rAX\u0001\u0005]\u0006lW\r\u0003\u0004\u0002rU\u0002\rAX\u0001\rI\u00164\u0017-\u001e7u-\u0006dW/Z\u0001\u000fO\u0016$\u0018J\u001c;Qe>\u0004XM\u001d;z)!\ti#a\u001e\u0002z\u0005m\u0004\"B(7\u0001\u0004\u0001\u0006BBA7m\u0001\u0007a\fC\u0004\u0002rY\u0002\r!!\f\u0002'\u001d,G/\u00128d_\u0012,G-\u0016:j'R\u0014\u0018N\\4\u0015\u0007y\u000b\t\t\u0003\u0004\u0002\u0004^\u0002\rAX\u0001\u0004kJL\u0017aE4fi\u0012+7m\u001c3fIV\u0013\u0018n\u0015;sS:<G\u0003BAE\u0003\u001b\u0003B!a\f\u0002\f&\u0019q-!\r\t\r\u0005\r\u0005\b1\u0001_\u0003U9W\r^*ue&tw\rT5tiB\u0013x\u000e]3sif$\u0002\"!\u0015\u0002\u0014\u0006U\u0015q\u0013\u0005\u0006\u001ff\u0002\r\u0001\u0015\u0005\u0007\u0003[J\u0004\u0019\u00010\t\u000f\u0005E\u0014\b1\u0001\u0002R\u0001")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;
    private List<String> scopes;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public void scopes_$eq(List<String> x$1) {
        this.scopes = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    private List<String> getStringListProperty(Config config, String name, List<String> defaultValue) {
        List<String> list;
        try {
            list = config.getStringList(name);
        }
        catch (ConfigException.Missing missing) {
            list = defaultValue;
        }
        return list;
    }

    public OidcConfig(Config config) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("xl.security.auth.providers.oidc.clientId");
        this.clientSecret = config.getString("xl.security.auth.providers.oidc.clientSecret");
        this.clientAuthMethod = this.getStringProperty(config, "xl.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.issuer = this.getDecodedUriString(config.getString("xl.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "xl.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(config.getString("xl.security.auth.providers.oidc.redirectUri"));
        this.postLogoutRedirectUri = this.getStringProperty(config, "xl.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("xl.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("xl.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "xl.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenIssuer = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "xl.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "xl.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "xl.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "xl.security.auth.providers.oidc.proxyPort", null);
        this.scopes = this.getStringListProperty(config, "xl.security.auth.providers.oidc.scopes", (List<String>)new ArrayList<String>(null){
            {
                this.add("openid");
            }
        });
    }
}

