/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.vsphere.ci;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.vsphere.steps.ValidateVSphereCredentialsStep;
import java.util.Arrays;
import java.util.List;

@Metadata(description="vCenter credentials", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Credentials
extends BaseConfigurationItem {
    @Property(required=true, label="URL", description="vCenter URL, e.g. https://vcenter.example.com/sdk")
    private String url;
    @Property(required=true, label="User name", description="vCenter username.")
    private String username;
    @Property(required=true, password=true, label="Password", description="vCenter password.")
    private String password;
    @Property(defaultValue="true", label="Ignore SSL certificate warnings", required=false)
    private boolean ignoreCert;

    @ControlTask(label="Validate credentials", description="Validate credentials by connecting to vCenter.")
    public List<Step> validateCredentials() {
        return Arrays.asList(new ValidateVSphereCredentialsStep(this));
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isIgnoreCert() {
        return this.ignoreCert;
    }

    public void setIgnoreCert(boolean ignoreCert) {
        this.ignoreCert = ignoreCert;
    }
}

