/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.HostFactory;
import com.xebialabs.deployit.plugin.cloud.util.MarkerChecker;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.ConnectionOptions;
import java.util.List;

public class WaitForInstancesStep
implements Step {
    private MarkerChecker markerChecker;

    public WaitForInstancesStep(MarkerChecker markerChecker) {
        this.markerChecker = markerChecker;
    }

    public int getOrder() {
        return 60;
    }

    public String getDescription() {
        return "Wait until created instances become available";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        List templates;
        List instances;
        try {
            instances = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.CREATED_INSTANCES.toString())));
            templates = (List)Preconditions.checkNotNull((Object)((List)ctx.getAttribute(ContextAttribute.USED_TEMPLATES.toString())));
        }
        catch (NullPointerException e) {
            ctx.logError("Can not find required context attribute", (Throwable)e);
            return StepExitCode.FAIL;
        }
        for (int i = 0; i < instances.size(); ++i) {
            ctx.logOutput("Waiting until instance " + (i + 1) + " is booting...");
            BaseHostTemplate instanceTpl = (BaseHostTemplate)((Object)templates.get(i));
            if (instanceTpl.getMarkerPath() == null) continue;
            Host host = HostFactory.fromTemplate(instanceTpl);
            String instancePublicAddress = instanceTpl.getInstanceIpAddress((String)instances.get(i));
            host.setProperty("address", (Object)instancePublicAddress);
            ConnectionOptions connectionOptions = new Host.ConnectionOptionsBuilder().getConnectionOptions(host);
            ctx.logOutput("Waiting until marker file " + instanceTpl.getMarkerPath() + " becomes available on " + instancePublicAddress + "...");
            this.markerChecker.waitForMarkerFileAppears((String)host.getProperty("protocol"), connectionOptions, instanceTpl.getMarkerPath(), instanceTpl.getBootTimeout(), instanceTpl.getRetryDelay());
        }
        return StepExitCode.SUCCESS;
    }
}

