/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.ConcurrentAccess;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.FileFault;
import com.vmware.vim25.ImportSpec;
import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidDatastore;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.OutOfBounds;
import com.vmware.vim25.ResourceConfigOption;
import com.vmware.vim25.ResourceConfigSpec;
import com.vmware.vim25.ResourcePoolRuntimeInfo;
import com.vmware.vim25.ResourcePoolSummary;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VAppConfigSpec;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VmConfigFault;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.HttpNfcLease;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualApp;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class ResourcePool
extends ManagedEntity {
    public ResourcePool(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public ResourceConfigSpec[] getChildConfiguration() {
        return (ResourceConfigSpec[])this.getCurrentProperty("childConfiguration");
    }

    public ResourceConfigSpec getConfig() {
        return (ResourceConfigSpec)this.getCurrentProperty("config");
    }

    public ComputeResource getOwner() throws InvalidProperty, RuntimeFault, RemoteException {
        return (ComputeResource)this.getManagedObject("owner");
    }

    public ResourcePool[] getResourcePools() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getResourcePools("resourcePool");
    }

    public ResourcePoolRuntimeInfo getRuntime() {
        return (ResourcePoolRuntimeInfo)this.getCurrentProperty("runtime");
    }

    public ResourcePoolSummary getSummary() {
        return (ResourcePoolSummary)this.getCurrentProperty("summary");
    }

    public VirtualMachine[] getVMs() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getVms("vm");
    }

    public Task createChildVM_Task(VirtualMachineConfigSpec config, HostSystem host) throws VmConfigFault, FileFault, OutOfBounds, InvalidName, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().createChildVM_Task(this.getMOR(), config, host == null ? null : host.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public VirtualApp createVApp(String name, ResourceConfigSpec resSpec, VAppConfigSpec configSpec, Folder vmFolder) throws InvalidName, DuplicateName, InsufficientResourcesFault, InvalidState, VmConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference vaMor = this.getVimService().createVApp(this.getMOR(), name, resSpec, configSpec, vmFolder == null ? null : vmFolder.getMOR());
        return new VirtualApp(this.getServerConnection(), vaMor);
    }

    public HttpNfcLease importVApp(ImportSpec spec, Folder folder, HostSystem host) throws VmConfigFault, FileFault, OutOfBounds, DuplicateName, InvalidName, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().importVApp(this.getMOR(), spec, folder == null ? null : folder.getMOR(), host == null ? null : host.getMOR());
        return new HttpNfcLease(this.getServerConnection(), mor);
    }

    public void refreshRuntime() throws RuntimeFault, RemoteException {
        this.getVimService().refreshRuntime(this.getMOR());
    }

    public Task registerChildVM_Task(String path, String name, HostSystem host) throws OutOfBounds, AlreadyExists, InvalidDatastore, NotFound, InvalidName, VmConfigFault, InsufficientResourcesFault, FileFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().registerChildVM_Task(this.getMOR(), path, name, host == null ? null : host.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public ResourcePool createResourcePool(String name, ResourceConfigSpec spec) throws InvalidName, DuplicateName, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ManagedObjectReference rpMor = this.getVimService().createResourcePool(this.getMOR(), name, spec);
        return new ResourcePool(this.getServerConnection(), rpMor);
    }

    public void destroyChildren() throws RuntimeFault, RemoteException {
        this.getVimService().destroyChildren(this.getMOR());
    }

    public void moveIntoResourcePool(ManagedEntity[] entities) throws DuplicateName, InsufficientResourcesFault, RuntimeFault, RemoteException {
        if (entities == null) {
            throw new IllegalArgumentException("entities must not be null.");
        }
        this.getVimService().moveIntoResourcePool(this.getMOR(), MorUtil.createMORs(entities));
    }

    public ResourceConfigOption queryResourceConfigOption() throws RuntimeFault, RemoteException {
        return this.getVimService().queryResourceConfigOption(this.getMOR());
    }

    public void updateChildResourceConfiguration(ResourceConfigSpec[] spec) throws InvalidState, InsufficientResourcesFault, RuntimeFault, RemoteException {
        this.getVimService().updateChildResourceConfiguration(this.getMOR(), spec);
    }

    public void updateConfig(String name, ResourceConfigSpec spec) throws InvalidName, DuplicateName, ConcurrentAccess, InsufficientResourcesFault, RuntimeFault, RemoteException {
        this.getVimService().updateConfig(this.getMOR(), name, spec);
    }
}

