package com.xebialabs.deployit.plugin.cloud.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;

import static com.google.common.base.Strings.isNullOrEmpty;

@Rule(clazz = MarkerFileValidation.Validator.class, type = "marker-file-check")
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface MarkerFileValidation {
    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<BaseHostTemplate> {

        @Override
        public void validate(BaseHostTemplate value, ValidationContext context) {
            if (!isNullOrEmpty(value.getMarkerPath())) {
                check(value.getConnectionType() != null, context, "Connection type");
                check(value.getOs() != null, context, "Operating system");
                check(!isNullOrEmpty(value.getUsername()), context, "Username");
                check(!isNullOrEmpty(value.getPassword()) || !isNullOrEmpty(value.getPrivateKeyFile()), context, "Password or private key file");
                if (value.getRetryDelay() <= 0) {
                    context.error("Retry delay should be > 0");
                }
            }
        }

        private void check(boolean b, ValidationContext context, String s) {
            if (!b) {
                context.error("%s should be provided when marker file set.", s);
            }
        }
    }
}
