package com.xebialabs.deployit.plugin.cloud.ci;

import java.util.List;
import java.util.concurrent.TimeoutException;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public interface InstantiatableCloudTemplate extends ConfigurationItem {

    /**
     * Produce Steps to instantiate this template in the cloud.
     * 
     * @param name
     *            base name for the instance
     * @param instanceSeq
     *            sequence number of this instance within the cloud Environment
     * @return the creation Steps
     */
    List<? extends Step> produceCreateSteps(String name, int instanceSeq);

    /**
     * Produce Steps to destroy the given ConfigurationItem in the cloud.
     * 
     * @param instance
     *            the ConfigurationItem to destroy
     * @return the destruction Steps
     */
    List<? extends Step> produceDestroySteps(ConfigurationItem instance);

    /**
     * Produce Steps to validate this template, typically verifying its XML descriptor (if present).
     * 
     * @return the validation Steps
     */
    List<? extends Step> produceValidationSteps();

    /**
     * Produce ConfigurationItems that belong to the given instance.
     * 
     * @param cloudId
     *            identifier of instance for which to return its CIs
     * @param repository
     *            the CI repository
     * @param repositoryPath
     * @return the CIs related to this instance.
     * @throws TimeoutException
     *             if retrieval of necessary data for instance CIs takes too long
     */
    List<ConfigurationItem> produceInstanceCIs(String cloudId, Repository repository, String repositoryPath) throws TimeoutException;

    /**
     * Waits until the instance is available, i.e. is completely booted, provisioned, etc.
     * 
     * @param cxt
     *            the excution context
     * @param cloudId
     *            the id of the instance
     * @throws TimeoutException
     */
    void waitForAvailability(ExecutionContext ctx, String cloudId) throws TimeoutException;
}