package com.xebialabs.deployit.plugin.cloud.util;

import java.util.*;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.google.common.collect.Lists.newArrayList;

public class CiUtils {

    public static String passwordMask = "********";


    /**
     * Returns a cloned CI, where all password field are replaced with {@link #passwordMask} value.
     * Applies for all the CIs that are somehow referenced from this CI (via direct reference, or as set, or as list of CIs).
     */
    public static ConfigurationItem securePasswords(ConfigurationItem ci) {
        return securePasswords(ci, Collections.EMPTY_LIST);
    }

    private static ConfigurationItem securePasswords(ConfigurationItem ci, List<String> ids) {
        if (ci == null) {
            return null;
        }

        if(ids.contains(ci.getId())) {
            throw new RuntimeException("Circular reference detected in CI tree");
        }

        final List<String> updatedIds = newArrayList(ids);
        updatedIds.add(ci.getId());

        Function<ConfigurationItem, Object> secureCollection = new Function<ConfigurationItem, Object>() {
                @Override
                public Object apply(ConfigurationItem ci) {
                    return securePasswords(ci, updatedIds);
                }
            };

        ConfigurationItem ciWithoutPasswords = ci.getType().getDescriptor().newInstance(ci.getId());

        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {

            Object newValue;

            switch (pd.getKind()) {
                case CI:
                    newValue = securePasswords((ConfigurationItem) pd.get(ci), updatedIds);
                    break;
                case SET_OF_CI:
                    newValue = Sets.newHashSet(Collections2.transform((Set<ConfigurationItem>) pd.get(ci), secureCollection));
                    break;
                case LIST_OF_CI:
                    newValue = Lists.transform((List<ConfigurationItem>) pd.get(ci), secureCollection);
                    break;
                default:
                    newValue = pd.isPassword() ? CiUtils.passwordMask : pd.get(ci);
            }

            ciWithoutPasswords.setProperty(pd.getName(), newValue);
        }

        return ciWithoutPasswords;
    }
}
