package com.xebialabs.deployit.plugin.cloud.step.rule;

import java.io.Serializable;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

/**
 * Implementations help to check list of CIs.
 * All implementations should be {@link Serializable} because normally check is passed into
 * step constructor and saved as class property.
 */
public interface ResultCheck extends Serializable {

    public void check(List<? extends ConfigurationItem> cis) throws Failed;

    @SuppressWarnings("serial")
    public static class Failed extends Exception {

        public Failed(final String message) {
            super(message);
        }

        public Failed(final String message, final Throwable cause) {
            super(message, cause);
        }

    }

}
