package com.xebialabs.deployit.plugin.cloud.ci;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import com.google.common.collect.Sets;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.cloud.step.CheckEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.step.DeleteCloudEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.step.WipeEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.util.CiFilters;
import com.xebialabs.deployit.plugin.overthere.Host;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
@Metadata(description = "Cloud environment", root = Metadata.ConfigurationItemRoot.ENVIRONMENTS)
public class Environment extends com.xebialabs.deployit.plugin.api.udm.Environment {

    @Property(required = true, label = "Template", category = "Cloud", description = "Template which was used to create this environment")
    private EnvironmentTemplate template;

    @Property(required = true, label = "Linked CIs", category = "Cloud", description = "CIs that were described in the template of this cloud environment and created along with it")
    private Set<ConfigurationItem> linkedCis = newHashSet();

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public Set<Host> getLinkedHosts() {
        // This cast is legal because we filter first
        return (Set<Host>)(Set)Sets.filter(linkedCis, CiFilters.CloudHosts);
    }

    public EnvironmentTemplate getTemplate() {
        return template;
    }

    public void setTemplate(final EnvironmentTemplate template) {
        this.template = template;
    }

    public Set<ConfigurationItem> getLinkedCis() {
        return linkedCis;
    }

    public void setLinkedCis(final Set<ConfigurationItem> linkedCis) {
        this.linkedCis = linkedCis;
    }

    /**
     * You should not rename this method, because it is used in UI
     */
    @ControlTask(label = "Destroy", description = "Shut down all related cloud instances and remove all related CIs")
    public List<? extends Step> destroy() {
        ArrayList<Step> steps = newArrayList(new CheckEnvironmentStep(getId()), new WipeEnvironmentStep(this));

        for (Host cloudHost : getLinkedHosts()) {
            BaseHostTemplate template = cloudHost.getProperty("template");
            steps.addAll(template.produceDestroySteps(cloudHost));
        }

        steps.add(new DeleteCloudEnvironmentStep(this));
        return steps;
    }
}

