/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.ci;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.cloud.ci.InstantiatableHostTemplate;
import com.xebialabs.deployit.plugin.cloud.step.WaitForInstancesStep;
import com.xebialabs.deployit.plugin.ec2.access.EC2Adapter;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import com.xebialabs.deployit.plugin.ec2.steps.CreateInstanceStep;
import com.xebialabs.deployit.plugin.ec2.steps.DestroyInstanceStep;
import com.xebialabs.deployit.plugin.ec2.util.EC2InstanceType;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.jclouds.ec2.domain.RunningInstance;

@Metadata(description="Amazon EC2 instance template", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class HostTemplate
extends InstantiatableHostTemplate {
    @Property(required=true, label="EC2 credentials", description="The EC2 credentials to use when communicating with the AWS API.")
    private Credentials credentials;
    @Property(required=false, label="Groups", description="IDs of EC2 security groups to associate with the instance.")
    private Set<String> groups;
    @Property(required=false, label="IAM Instance Profile ARN", description="ARN of the IAM instance profile to associate with the instance.")
    private String iamInstanceProfileArn;
    @Property(required=false, label="VPC subnet ID", description="The subnet ID for Amazon VPC within which to launch the image.")
    private String vpcSubnetId;
    @Property(required=true, label="Image ID (AMI)", description="The Amazon Machine Image ID (AMI) to use when creating an instance.")
    private String ami;
    @Property(required=true, label="Region", description="The EC2 region to create the instance in (e.g., us-west-1 or eu-west-1)")
    private String region;
    @Property(required=true, label="Instance type", description="The EC2 instance type to create.")
    private EC2InstanceType instanceType;
    @Property(required=true, label="Key pair", description="Name of the EC2 key pair to use. It should be already present on EC2.")
    private String keyPair;
    @Property(required=false, label="Tags", description="EC2 tags ")
    private Map<String, String> tags;

    public EC2InstanceType getInstanceType() {
        return this.instanceType;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getIamInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    public String getVpcSubnetId() {
        return this.vpcSubnetId;
    }

    public String getAmi() {
        return this.ami;
    }

    public String getRegion() {
        return this.region;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setIamInstanceProfileArn(String iamInstanceProfileArn) {
        this.iamInstanceProfileArn = iamInstanceProfileArn;
    }

    public void setVpcSubnetId(String vpcSubnetId) {
        this.vpcSubnetId = vpcSubnetId;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setInstanceType(EC2InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    public List<? extends Step> produceCreateSteps(String envName, int instanceSeq) {
        String instanceLabel = instanceSeq == 0 ? envName : envName + " (" + this.getName() + ") #" + instanceSeq;
        return Arrays.asList(new CreateInstanceStep(this, new EC2Adapter(this.getCredentials()), instanceLabel), new WaitForInstancesStep());
    }

    public List<? extends Step> produceDestroySteps(ConfigurationItem instance) {
        return Arrays.asList(new DestroyInstanceStep(instance, new ServiceFactory()));
    }

    public String getInstanceIpAddress(String cloudId) {
        try {
            RunningInstance running = new EC2Adapter(this.getCredentials()).waitForRunningInstance(this.getRegion(), cloudId, this.getBootTimeout(), this.getRetryDelay());
            return Strings.isNullOrEmpty((String)this.vpcSubnetId) ? running.getIpAddress() : running.getPrivateIpAddress();
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

