package com.xebialabs.deployit.plugin.ec2.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.ec2.ci.HostTemplate;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;

@SuppressWarnings("serial")
public class DestroyInstanceStep implements Step {

    private ServiceFactory serviceFactory;

    private String cloudId;
    private HostTemplate template;

    public DestroyInstanceStep(final ConfigurationItem instance, final ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
        this.cloudId = instance.getProperty("cloudId");
        this.template = instance.getProperty("template");
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Destroy EC2 instance " + cloudId;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("Destroying instance " + cloudId + " with credentials " + template.getCredentials().getId());
        serviceFactory.getEC2Adapter(template.getCredentials()).shutDown(template.getRegion(), cloudId);
        return StepExitCode.SUCCESS;
    }
}
