/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.io.payloads.BasePayload;
import org.jclouds.io.payloads.Part;

public class MultipartForm
extends BasePayload<Iterable<? extends Part>> {
    public static final String BOUNDARY = "--JCLOUDS--";
    private static final String rn = "\r\n";
    private static final String dd = "--";
    private boolean isRepeatable;
    private final InputSupplier<? extends InputStream> chain;

    public MultipartForm(String boundary, Iterable<? extends Part> content) {
        super(content);
        this.getContentMetadata().setContentType("multipart/form-data; boundary=" + boundary);
        this.getContentMetadata().setContentLength(0L);
        String boundaryrn = boundary + rn;
        this.isRepeatable = true;
        InputSupplier chain = ByteStreams.join((InputSupplier[])new InputSupplier[0]);
        for (Part part : content) {
            if (!part.isRepeatable()) {
                this.isRepeatable = false;
            }
            this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + part.getContentMetadata().getContentLength());
            chain = ByteStreams.join((InputSupplier[])new InputSupplier[]{chain, this.addLengthAndReturnHeaders(boundaryrn, part), part, this.addLengthAndReturnRn()});
        }
        this.chain = chain = ByteStreams.join((InputSupplier[])new InputSupplier[]{chain, this.addLengthAndReturnFooter(boundary)});
    }

    public MultipartForm(String boundary, Part ... parts) {
        this(boundary, Lists.newArrayList((Object[])parts));
    }

    public MultipartForm(Part ... parts) {
        this(BOUNDARY, parts);
    }

    private InputSupplier<? extends InputStream> addLengthAndReturnRn() {
        this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + (long)rn.length());
        return ByteStreams.newInputStreamSupplier((byte[])rn.getBytes());
    }

    private InputSupplier<? extends InputStream> addLengthAndReturnHeaders(String boundaryrn, Part part) {
        StringBuilder builder = new StringBuilder(dd).append(boundaryrn);
        for (Map.Entry entry : part.getHeaders().entries()) {
            String header = String.format("%s: %s%s", entry.getKey(), entry.getValue(), rn);
            builder.append(header);
        }
        builder.append(rn);
        this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + (long)builder.length());
        return ByteStreams.newInputStreamSupplier((byte[])builder.toString().getBytes());
    }

    private InputSupplier<? extends InputStream> addLengthAndReturnFooter(String boundary) {
        String end = dd + boundary + dd + rn;
        this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + (long)end.length());
        return ByteStreams.newInputStreamSupplier((byte[])end.getBytes());
    }

    @Override
    public InputStream openStream() throws IOException {
        return (InputStream)this.chain.getInput();
    }

    @Override
    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    @Override
    public void release() {
        for (Part part : (Iterable)this.content) {
            part.release();
        }
    }
}

