/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Date;
import java.util.Map;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.http.functions.ParseSax;

public class BlockDeviceMappingHandler
extends ParseSax.HandlerWithResult<Map<String, BlockDevice>> {
    private StringBuilder currentText = new StringBuilder();
    private Map<String, BlockDevice> ebsBlockDevices = Maps.newHashMap();
    private String deviceName;
    private String volumeId;
    private boolean deleteOnTermination = true;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    protected final DateCodec dateCodec;

    @Inject
    public BlockDeviceMappingHandler(DateCodecFactory dateCodecFactory) {
        this.dateCodec = dateCodecFactory.iso8601();
    }

    public Map<String, BlockDevice> getResult() {
        return this.ebsBlockDevices;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("deviceName")) {
            this.deviceName = this.currentText.toString().trim();
        } else if (qName.equals("volumeId")) {
            this.volumeId = this.currentText.toString().trim();
        } else if (qName.equals("deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (qName.equals("status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("attachTime")) {
            this.attachTime = this.dateCodec.toDate(this.currentText.toString().trim());
        } else if (qName.equals("item")) {
            this.ebsBlockDevices.put(this.deviceName, new BlockDevice(this.volumeId, this.attachmentStatus, this.attachTime, this.deleteOnTermination));
            this.volumeId = null;
            this.deviceName = null;
            this.deleteOnTermination = true;
            this.attachmentStatus = null;
            this.attachTime = null;
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

