/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.config;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Atomics;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateBuilderImpl;
import org.jclouds.aws.ec2.compute.config.AWSEC2BindComputeSuppliersByClass;
import org.jclouds.aws.ec2.compute.config.AWSEC2ComputeServiceDependenciesModule;
import org.jclouds.aws.ec2.compute.config.ImageQuery;
import org.jclouds.aws.ec2.compute.functions.AWSRunningInstanceToNodeMetadata;
import org.jclouds.aws.ec2.compute.functions.PresentSpotRequestsAndInstances;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2CreateNodesInGroupThenAddToSet;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2DestroyNodeStrategy;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2GetNodeMetadataStrategy;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2ListNodesStrategy;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2ReviseParsedImage;
import org.jclouds.aws.ec2.compute.strategy.CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.aws.ec2.compute.suppliers.AWSEC2HardwareSupplier;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.config.EC2BindComputeStrategiesByClass;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.compute.loaders.RegionAndIdToImage;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.strategy.EC2CreateNodesInGroupThenAddToSet;
import org.jclouds.ec2.compute.strategy.EC2DestroyNodeStrategy;
import org.jclouds.ec2.compute.strategy.EC2GetNodeMetadataStrategy;
import org.jclouds.ec2.compute.strategy.EC2ListNodesStrategy;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.compute.suppliers.EC2HardwareSupplier;
import org.jclouds.ec2.compute.suppliers.RegionAndNameToImageSupplier;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.SetAndThrowAuthorizationExceptionSupplier;

public class AWSEC2ComputeServiceContextModule
extends BaseComputeServiceContextModule {
    protected void configure() {
        super.configure();
        this.installDependencies();
        this.install((Module)new EC2BindComputeStrategiesByClass());
        this.install((Module)new AWSEC2BindComputeSuppliersByClass());
        this.bind(ReviseParsedImage.class).to(AWSEC2ReviseParsedImage.class);
        this.bind(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class).to(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class);
        this.bind(EC2HardwareSupplier.class).to(AWSEC2HardwareSupplier.class);
        this.bind(EC2TemplateBuilderImpl.class).to(AWSEC2TemplateBuilderImpl.class);
        this.bind(EC2GetNodeMetadataStrategy.class).to(AWSEC2GetNodeMetadataStrategy.class);
        this.bind(EC2ListNodesStrategy.class).to(AWSEC2ListNodesStrategy.class);
        this.bind(EC2DestroyNodeStrategy.class).to(AWSEC2DestroyNodeStrategy.class);
        this.bind(PresentInstances.class).to(PresentSpotRequestsAndInstances.class);
        this.bind(EC2CreateNodesInGroupThenAddToSet.class).to(AWSEC2CreateNodesInGroupThenAddToSet.class);
        this.bind(RunningInstanceToNodeMetadata.class).to(AWSRunningInstanceToNodeMetadata.class);
    }

    protected void installDependencies() {
        this.install((Module)new AWSEC2ComputeServiceDependenciesModule());
    }

    protected boolean shouldEagerlyParseImages(Injector injector) {
        Map queries = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, ImageQuery.class));
        return queries.size() > 0;
    }

    protected Supplier<Set<? extends Image>> supplyNonParsingImageCache(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier, Injector injector) {
        final Supplier cache = (Supplier)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<RegionAndName, ? extends Image>>>(){}));
        return new Supplier<Set<? extends Image>>(){

            public Set<? extends Image> get() {
                return ImmutableSet.copyOf(((LoadingCache)cache.get()).asMap().values());
            }
        };
    }

    @Provides
    @Singleton
    protected Supplier<CacheLoader<RegionAndName, Image>> provideRegionAndNameToImageSupplierCacheLoader(final RegionAndIdToImage delegate) {
        return Suppliers.ofInstance((Object)new CacheLoader<RegionAndName, Image>(){
            private final AtomicReference<AuthorizationException> authException = Atomics.newReference();

            public Image load(final RegionAndName key) throws Exception {
                Supplier<Image> rawSupplier = new Supplier<Image>(){

                    public Image get() {
                        try {
                            return delegate.load(key);
                        }
                        catch (ExecutionException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                };
                return (Image)new SetAndThrowAuthorizationExceptionSupplier((Supplier)rawSupplier, this.authException).get();
            }
        });
    }

    @Provides
    @Singleton
    protected Supplier<LoadingCache<RegionAndName, ? extends Image>> provideRegionAndNameToImageSupplierCache(RegionAndNameToImageSupplier supplier) {
        return supplier;
    }

    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        return ((EC2TemplateOptions)options.as(EC2TemplateOptions.class)).userData("#cloud-config\nrepo_upgrade: none\n".getBytes());
    }

    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.of((Object)i.getInstance(ImageExtension.class));
    }

    protected Optional<SecurityGroupExtension> provideSecurityGroupExtension(Injector i) {
        return Optional.of((Object)i.getInstance(SecurityGroupExtension.class));
    }
}

