/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.features.PlacementGroupApi;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.EC2ComputeService;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;

@Singleton
public class AWSEC2ComputeService
extends EC2ComputeService {
    private final LoadingCache<RegionAndName, String> placementGroupMap;
    private final Predicate<PlacementGroup> placementGroupDeleted;
    private final AWSEC2Api client;

    @Inject
    protected AWSEC2ComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, AWSEC2Api client, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap, @Named(value="PLACEMENT") LoadingCache<RegionAndName, String> placementGroupMap, @Named(value="DELETED") Predicate<PlacementGroup> placementGroupDeleted, Optional<ImageExtension> imageExtension, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.ec2.generate-instance-names") boolean generateInstanceNames, Optional<SecurityGroupExtension> securityGroupExtension) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, runScriptOnNodeFactory, initAdminAccess, persistNodeCredentials, timeouts, userExecutor, (EC2Api)client, credentialsMap, securityGroupMap, imageExtension, namingConvention, generateInstanceNames, securityGroupExtension);
        this.client = client;
        this.placementGroupMap = placementGroupMap;
        this.placementGroupDeleted = placementGroupDeleted;
    }

    @VisibleForTesting
    void deletePlacementGroup(String region, String group) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)group), (Object)"group must be defined");
        String placementGroup = String.format("jclouds#%s#%s", group, region);
        try {
            if (((PlacementGroupApi)this.client.getPlacementGroupApi().get()).describePlacementGroupsInRegion(region, placementGroup).size() > 0) {
                this.logger.debug(">> deleting placementGroup(%s)", new Object[]{placementGroup});
                try {
                    ((PlacementGroupApi)this.client.getPlacementGroupApi().get()).deletePlacementGroupInRegion(region, placementGroup);
                    Preconditions.checkState((boolean)this.placementGroupDeleted.apply((Object)new PlacementGroup(region, placementGroup, "cluster", PlacementGroup.State.PENDING)), (Object)String.format("placementGroup region(%s) name(%s) failed to delete", region, placementGroup));
                    this.placementGroupMap.invalidate((Object)new RegionAndName(region, placementGroup));
                    this.logger.debug("<< deleted placementGroup(%s)", new Object[]{placementGroup});
                }
                catch (IllegalStateException e) {
                    this.logger.debug("<< inUse placementGroup(%s)", new Object[]{placementGroup});
                }
            }
        }
        catch (UnsupportedOperationException e) {
            this.logger.trace("<< placementGroups unsupported in region %s", new Object[]{region});
        }
    }

    protected void cleanUpIncidentalResources(String region, String group) {
        super.cleanUpIncidentalResources(region, group);
        this.deletePlacementGroup(region, group);
    }

    public AWSEC2TemplateOptions templateOptions() {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.templateOptions());
    }
}

