/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.http.HttpRequest;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.rest.Binder;

public class BindIpPermissionsToIndexedFormParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Iterable), (Object)"this binder is only valid for Iterable<IpPermission>");
        ImmutableMultimap.Builder formBuilder = ImmutableMultimap.builder();
        int index = 0;
        for (IpPermission perm : (Iterable)input) {
            formBuilder.putAll(IpPermissions.buildFormParametersForIndex(index++, perm));
        }
        ImmutableMultimap forms = formBuilder.build();
        return (R)(forms.size() == 0 ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }
}

