class PropertyUtil(object):

    @classmethod
    def to_string(cls, prop_value, kind):
        if kind == 'SET_OF_STRING':
            str_value = cls._collection_str(sorted([c for c in prop_value]))
        elif kind == 'LIST_OF_STRING':
            str_value = cls._collection_str(prop_value)
        elif kind == 'MAP_STRING_STRING':
            str_value = cls._map_str(prop_value)
        else:
            str_value = unicode(prop_value).encode('latin-1', 'replace').decode('utf-8', 'replace')

        if str_value in ["", "None", "null"]:
            return None

        return str_value

    @classmethod
    def _collection_str(cls, collection):
        return '[%s]' % ', '.join(map(lambda e: "'%s'" % str(e), collection))

    @classmethod
    def _map_str(cls, map_obj):
        stringed_objects = []
        for key in sorted(map_obj):
            stringed_objects.append("'%s': '%s'" % (key, map_obj[key]))
        return '{%s}' % ', '.join(stringed_objects)
