/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wps.contributor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployed;
import com.xebialabs.deployit.plugin.wps.contributor.WpsEarModulePredicate;
import java.util.HashMap;
import java.util.Map;

public class BpcStopForceDeleteProcesses {
    @Contributor
    public static void applyBpcStopForceDeleteProcesses(Deltas deltas, DeploymentPlanningContext ctx) {
        BpcStopForceDeleteProcesses contributor = new BpcStopForceDeleteProcesses();
        contributor.apply(deltas, ctx);
    }

    private void apply(Deltas deltas, DeploymentPlanningContext ctx) {
        Iterable<Delta> wpsEarDeltas = this.findWpsEarDeltas(deltas);
        Boolean bpcForceUndeployment = (Boolean)ctx.getDeployedApplication().getProperty("bpcForceUndeployment");
        for (Delta wpsEarDelta : wpsEarDeltas) {
            String script;
            Integer order;
            Operation operation = wpsEarDelta.getOperation();
            if (operation != Operation.MODIFY && operation != Operation.DESTROY) continue;
            ExtensibleDeployed<?> wpsEarModule = this.extractDeployed(wpsEarDelta);
            Boolean stopProcessAndTaskTemplates = (Boolean)wpsEarModule.getProperty("stopProcessAndTaskTemplates");
            Boolean deleteInstancesAndStopTemplates = (Boolean)wpsEarModule.getProperty("deleteInstancesAndStopTemplates");
            if (bpcForceUndeployment.booleanValue() || deleteInstancesAndStopTemplates.booleanValue()) {
                order = (Integer)wpsEarModule.getProperty("deleteBpcTemplatesScriptOrder");
                script = (String)wpsEarModule.getProperty("deleteBpcTemplatesScript");
                this.addStep(order, script, "Deleting processes and tasks for " + wpsEarModule.getName(), wpsEarModule, ctx);
                continue;
            }
            if (!stopProcessAndTaskTemplates.booleanValue()) continue;
            order = (Integer)wpsEarModule.getProperty("stopBpcTemplatesScriptOrder");
            script = (String)wpsEarModule.getProperty("stopBpcTemplatesScript");
            this.addStep(order, script, "Stopping processes and tasks for " + wpsEarModule.getName(), wpsEarModule, ctx);
        }
    }

    private void addStep(Integer order, String script, String description, ExtensibleDeployed<?> deployed, DeploymentPlanningContext ctx) {
        PythonDeploymentStep step = new PythonDeploymentStep(order.intValue(), ((WasContainer)deployed.getContainer()).getManagingContainer(), script, this.getPythonVars(ctx.getDeployedApplication(), deployed), description);
        ctx.addStep((Step)step);
    }

    private ExtensibleDeployed<?> extractDeployed(Delta delta) {
        if (delta.getDeployed() == null) {
            return (ExtensibleDeployed)delta.getPrevious();
        }
        return (ExtensibleDeployed)delta.getDeployed();
    }

    private Map<String, Object> getPythonVars(DeployedApplication deployedApplication, ExtensibleDeployed<?> wpsEarModule) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("deployed", wpsEarModule);
        Boolean exposeDeployedApplication = (Boolean)wpsEarModule.getProperty("exposeDeployedApplication");
        if (exposeDeployedApplication.booleanValue()) {
            Preconditions.checkNotNull((Object)deployedApplication, (Object)"deployedApplication is null");
            pythonVars.put("deployedApplication", deployedApplication);
        }
        return pythonVars;
    }

    private Iterable<Delta> findWpsEarDeltas(Deltas deltas) {
        return Iterables.filter((Iterable)deltas.getDeltas(), (Predicate)new WpsEarModulePredicate());
    }
}

