import os
def findApplicationModuleType(appName):
    descriptorFile = "%s/config/cells/%s/applications/%s.ear/deployments/%s/META-INF/application.xml" %(container.wasHome, container.cellName, appName, appName)
    appxml =  open(descriptorFile, 'r').read()
    start_string = "<display-name>"
    end_string = "</display-name>"
    start_index = appxml.find(start_string) + len(start_string)
    end_index = appxml.find(end_string)
    displayName = appxml[start_index:end_index]
    if re.match( r'.+([0-9a-f]{10,})', displayName) or displayName.endswith("_jar") or displayName.endswith("_war"):
        module = AdminApp.listModules(appName).splitlines()
        if len(module) == 1:
            if module[0].endswith("META-INF/ejb-jar.xml"):
                return "ejb"
            elif module[0].endswith("WEB-INF/web.xml"):
                return "war"

    bpcDeploymentFile = "%s/config/cells/%s/applications/%s.ear/deployments/%s/deployment-bpc.xml" %(container.wasHome, container.cellName, appName, appName)
    if os.path.isfile(bpcDeploymentFile):
        return "wpsEar"

    return "ear"

def getVirtualHostIdForApp(appName):
    appData = AdminApp.view(appName,["-MapWebModToVH"]).splitlines()
    for line in appData:
        if line.startswith("Virtual host: "):
            vhost = line.split(": ")[1]
            return container.id + "/" + vhost.strip()

    print "Cannot find virtual host for application ", appName
    return None
