#*******************************************************************************************************
# convert a string as returned by AdminConfig.show[Attribute] to a Jython list
#*******************************************************************************************************
def wsadminToList(inStr):
	outList=[]
	if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
		inStr = inStr[1:-1]
		tmpList = inStr.split(" ")
	else:
		tmpList = inStr.split("\n")		#splits for Windows or Linux
	for item in tmpList:
		item = item.rstrip();			#removes any Windows "\r"
		if (len(item)>0):
			outList.append(item)
	return outList
#endDef

def lookupComponentById(allComponents, id):
	for component in allComponents:
		componentId=AdminConfig.showAttribute(component, 'id')
		if componentId ==  id:
			return component
	return None

def getDsFromSiBus(siBus):
	bus=AdminConfig.showAttribute(siBus, 'bus')
	wbiMEs=AdminConfig.showAttribute(bus, 'wbiMEs')
	if wbiMEs.startswith('[') and wbiMEs.endswith(']'):
		wbiMEs=wbiMEs[1:len(wbiMEs) - 1]
	dataSrc=AdminConfig.showAttribute(wbiMEs, 'dataSrc')
	return dataSrc
	
def getWbiMEsFromSiBus(siBus):
	bus=AdminConfig.showAttribute(siBus, 'bus')
	wbiMEs=AdminConfig.showAttribute(bus, 'wbiMEs')
	if wbiMEs.startswith('[') and wbiMEs.endswith(']'):
		wbiMEs=wbiMEs[1:len(wbiMEs) - 1]
	return wbiMEs

	
def printDsAttributes(dataSrc, wsadminToList):
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	attributes=AdminConfig.showAttribute(dataSrc,'attributes')
	for attribute in wsadminToList(attributes):
		name=AdminConfig.showAttribute(attribute,'name')
		value=AdminConfig.showAttribute(attribute,'value')
		print 'ds attribute found: ' + attribute + ' with name: ' + name + ' value: ' + value

def printDsProperties(dataSrc, wsadminToList):
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	properties=AdminConfig.showAttribute(dataSrc,'properties')
	for property in wsadminToList(properties):
		name=AdminConfig.showAttribute(property,'name')
		value=AdminConfig.showAttribute(property,'value')
		print 'ds property found: ' + property + ' with name: ' + name + ' value: ' + value
		
def setDsAttribute(dataSrc, wsadminToList, attributeName, newAttributeValue):
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	attributes=AdminConfig.showAttribute(dataSrc,'attributes')
	for attribute in wsadminToList(attributes):
		name=AdminConfig.showAttribute(attribute,'name')
		if name == attributeName:
			AdminConfig.modify(attribute, '[["value" %s]]' % newAttributeValue)
			
def setDsAttributeWithQuotes(dataSrc, wsadminToList, attributeName, newAttributeValue):
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	attributes=AdminConfig.showAttribute(dataSrc,'attributes')
	for attribute in wsadminToList(attributes):
		name=AdminConfig.showAttribute(attribute,'name')
		if name == attributeName:
			AdminConfig.modify(attribute, '[["value" "%s"]]' % newAttributeValue)
		
def setDsProperty(dataSrc, wsadminToList, propertyName, newPropertyValue):
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	properties=AdminConfig.showAttribute(dataSrc,'properties')
	for property in wsadminToList(properties):
		name=AdminConfig.showAttribute(property,'name')
		if name == propertyName:
			AdminConfig.modify(property, '[["value" %s]]' % newPropertyValue)

def setDirectDsProperty(dataSrc, propertyName, newPropertyValue):
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	AdminConfig.modify(dataSrc, '[[%s %s]]' % (propertyName, newPropertyValue))
	
def setUsernamePasswordAndDescription(dataSrc, wbiMEs, newUserName, newPassword, newDescription):
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	authAlias=AdminConfig.showAttribute(dataSrc,'authAlias')
	AdminConfig.modify(authAlias, '[[userName %s]]' % newUserName)
	AdminConfig.modify(authAlias, '[[password %s]]' % newPassword)
	if newDescription is not None:
		AdminConfig.modify(authAlias, '[[description "%s"]]' % newDescription)
	if wbiMEs is not None:
		authAlias=AdminConfig.showAttribute(wbiMEs,'authAlias')
		AdminConfig.modify(authAlias, '[[userName %s]]' % newUserName)
		AdminConfig.modify(authAlias, '[[password %s]]' % newPassword)
		if newDescription is not None:
			AdminConfig.modify(authAlias, '[[description "%s"]]' % newDescription)

			
def setAttributesAndProperties(dataSrc, wbiMEs, deployedSubItem, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription):
	setDsAttribute(dataSrc, wsadminToList, 'jndiName', deployedSubItem.jndiName)
	setDsProperty(dataSrc, wsadminToList, 'databaseName', deployedSubItem.databaseName)
	setDirectDsProperty(dataSrc, 'createTable', deployedSubItem.createTables)
	description=None
	if hasattr(deployedSubItem, 'description'):
		description=deployedSubItem.description
		setDsAttributeWithQuotes(dataSrc, wsadminToList, 'description', description)
	setUsernamePasswordAndDescription(dataSrc, wbiMEs, deployedSubItem.databaseUser, deployedSubItem.databasePassword, description)
	setDsProperty(dataSrc, wsadminToList, 'serverName', deployedSubItem.databaseServer)
	if dataSrc.startswith('[') and dataSrc.endswith(']'):
		dataSrc=dataSrc[1:len(dataSrc) - 1]
	if deployedSubItem.databaseProvider == 'ORA':
		oldProvider = AdminConfig.showAttribute(dataSrc, 'provider')
		print 'derived old provider: '
		print AdminConfig.show(oldProvider)
		oldScope = AdminConfig.showAttribute(oldProvider, 'scope')
		oldDbComponent = AdminConfig.showAttribute(oldProvider, 'dbcomponent')
		print 'old scope: ' + oldScope
		print 'old dbcomponent: ' + oldDbComponent
		scope = [ 'scope', '%s' % (oldScope) ]
		databaseType = [ 'databaseType', 'ORACLE' ]
		providerType = [ 'providerType', 'Oracle JDBC Driver' ]
		implementationType = [ 'implementationType', 'XA data source' ]
		dbcomponent = [ 'dbcomponent', '%s' % oldDbComponent ]
		providerAttrs = [scope, databaseType, providerType, implementationType, dbcomponent]
		newProvider = AdminConfig.create('WBIDBProvider', dataSrc, providerAttrs, 'provider')
		prop1 = [['name', 'URL'],['value', 'jdbc:oracle:thin:@%s:%s:%s' % (deployedSubItem.databaseServer, deployedSubItem.databasePort, deployedSubItem.databaseName)],['type','String']]
		prop2 = [['name', 'driverType'],['value', 'thin'],['type','string']]
		props = [prop1, prop2]
		properties = AdminConfig.showAttribute(dataSrc, 'properties')
		newProp = AdminConfig.create('WBIProperty', dataSrc, prop1, 'properties')
		newProp = AdminConfig.create('WBIProperty', dataSrc, prop2, 'properties')
	elif deployedSubItem.databaseProvider == 'DB2':
		oldProvider = AdminConfig.showAttribute(dataSrc, 'provider')
		print 'derived old provider: '
		print AdminConfig.show(oldProvider)
		oldScope = AdminConfig.showAttribute(oldProvider, 'scope')
		oldDbComponent = AdminConfig.showAttribute(oldProvider, 'dbcomponent')
		print 'old scope: ' + oldScope
		print 'old dbcomponent: ' + oldDbComponent
		scope = [ 'scope', '%s' % (oldScope) ]
		databaseType = [ 'databaseType', 'DB2_UNIVERSAL' ]
		providerType = [ 'providerType', 'DB2 Universal JDBC Driver Provider' ]
		implementationType = [ 'implementationType', 'XA data source' ]
		dbcomponent = [ 'dbcomponent', '%s' % oldDbComponent ]
		providerAttrs = [scope, databaseType, providerType, implementationType, dbcomponent]
		newProvider = AdminConfig.create('WBIDBProvider', dataSrc, providerAttrs, 'provider')
	else:
		print 'WARNING unrecognized database provider'
		print '   This implies you get a default provider for the datasource with jndi name ' + deployedSubItem.jndiName

def setAuthAliasUsernameAndPassword(authAliases, deployedSubItem):
	if authAliases.startswith('[') and authAliases.endswith(']'):
		authAliases=authAliases[1:len(authAliases) - 1]
	AdminConfig.modify(authAliases, '[[userName %s]]' % deployedSubItem.authenticationAliasUser)
	AdminConfig.modify(authAliases, '[[password %s]]' % deployedSubItem.authenticationAliasPassword)


print 'Creating a DeploymentEnv...'

AdminTask.createDeploymentEnvDef ('[-topologyName %s -topologyPattern RemoteMessagingAndSupport -topologyRuntime WPS]' % (deployed.deploymentEnvironmentName))
deplEnvId = AdminConfig.getid('/WBITopology:%s' % (deployed.deploymentEnvironmentName))


components=AdminConfig.showAttribute(deplEnvId,'components')
allComponents=wsadminToList(components)

print '  '
component=lookupComponentById(allComponents, 'WBI_CEI')
dataSrc=AdminConfig.showAttribute(component, 'dataSrc')
setAttributesAndProperties(dataSrc, None, deployed.cei, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)
siBuses=AdminConfig.showAttribute(component, 'siBuses')
for siBus in wsadminToList(siBuses):
	dataSrc=getDsFromSiBus(siBus)
	wbiMEs=getWbiMEsFromSiBus(siBus)
	setAttributesAndProperties(dataSrc, wbiMEs, deployed.ceime, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)
authAliases=AdminConfig.showAttribute(component, 'authAliases')
setAuthAliasUsernameAndPassword(authAliases, deployed.cei)

component=lookupComponentById(allComponents, 'WBI_BPC')
dataSrc=AdminConfig.showAttribute(component, 'dataSrc')
print 'found ds on component: ' + dataSrc
setAttributesAndProperties(dataSrc, None, deployed.bpc, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)
siBuses=AdminConfig.showAttribute(component, 'siBuses')
for siBus in wsadminToList(siBuses):
	dataSrc=getDsFromSiBus(siBus)
	wbiMEs=getWbiMEsFromSiBus(siBus)
	setAttributesAndProperties(dataSrc, wbiMEs, deployed.bpcme, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)
authAliases=AdminConfig.showAttribute(component, 'authAliases')
setAuthAliasUsernameAndPassword(authAliases, deployed.bpc)

component=lookupComponentById(allComponents, 'WBI_BPCEventCollector')
dataSrc=AdminConfig.showAttribute(component, 'dataSrc')
setAttributesAndProperties(dataSrc, None, deployed.bpcrf, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)

component=lookupComponentById(allComponents, 'WBI_BSPACE')
dataSrc=AdminConfig.showAttribute(component, 'dataSrc')
setAttributesAndProperties(dataSrc, None, deployed.busSpace, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)

component=lookupComponentById(allComponents, 'WBI_SCA')
siBuses=AdminConfig.showAttribute(component, 'siBuses')
for siBus in wsadminToList(siBuses):
	dataSrc=getDsFromSiBus(siBus)
	wbiMEs=getWbiMEsFromSiBus(siBus)
	siBusName=AdminConfig.showAttribute(siBus,'name')
	if siBusName == 'SCA_system_bus':
		setAttributesAndProperties(dataSrc, wbiMEs, deployed.sca, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)
		authAliases=AdminConfig.showAttribute(component, 'authAliases')
		setAuthAliasUsernameAndPassword(authAliases, deployed.sca)
	if siBusName == 'SCA_app_bus':
		setAttributesAndProperties(dataSrc, wbiMEs, deployed.scame, wsadminToList, setDsAttribute, setDsAttributeWithQuotes, setDsProperty, setDirectDsProperty, setUsernamePasswordAndDescription)

for node in deployed.messagingInfrastructure:
	AdminTask.addNodeToDeploymentEnvDef('[-topologyName %s -nodeRuntime WPS -topologyRole Messaging -nodeName %s -serverCount 1]' % (deployed.deploymentEnvironmentName, node.name))
for node in deployed.supportingInfrastructure:
	AdminTask.addNodeToDeploymentEnvDef('[-topologyName %s -nodeRuntime WPS -topologyRole Support -nodeName %s -serverCount 1]' % (deployed.deploymentEnvironmentName, node.name))
for node in deployed.applicationDeploymentTarget:
	AdminTask.addNodeToDeploymentEnvDef('[-topologyName %s -nodeRuntime WPS -topologyRole ADT -nodeName %s -serverCount 1]' % (deployed.deploymentEnvironmentName, node.name))

# mark as deplEnv as "configured" this does not need a real date and user
# NB this requires a save and a sync to get the underlying xml file on the filesystem!!!
AdminConfig.save()
for node in deployed.messagingInfrastructure:
	sync = AdminControl.completeObjectName('type=NodeSync,node=' + node.name + ',*');
	AdminControl.invoke(sync, 'sync');
for node in deployed.supportingInfrastructure:
	sync = AdminControl.completeObjectName('type=NodeSync,node=' + node.name + ',*');
	AdminControl.invoke(sync, 'sync');
for node in deployed.applicationDeploymentTarget:
	sync = AdminControl.completeObjectName('type=NodeSync,node=' + node.name + ',*');
	AdminControl.invoke(sync, 'sync');

# now we have to lookup our deplEnv Id as in this session the id in 'deplEnvId' has changed!!!
allWbiTopologies = wsadminToList(AdminConfig.list('WBITopology'))
for wbiTopology in allWbiTopologies:
	name=AdminConfig.showAttribute(wbiTopology,'name')
	if name == deployed.deploymentEnvironmentName:
		print 'found it: ' + wbiTopology
		deplEnvId = wbiTopology

# next, set all statusses to 'Configured': of the deplEnv itself, all its roles and all its components
AdminConfig.modify(deplEnvId, '[[status Configured]]')
roles=AdminConfig.showAttribute(deplEnvId,'roles')
allRoles=wsadminToList(roles)
for role in allRoles:
	AdminConfig.modify(role, '[[status "%s"]]' % 'Configured')
components=AdminConfig.showAttribute(deplEnvId,'components')
allComponents=wsadminToList(components)
for component in allComponents:
	AdminConfig.modify(component, '[[status "%s"]]' % 'Configured')

AdminConfig.save()
for node in deployed.messagingInfrastructure:
	sync = AdminControl.completeObjectName('type=NodeSync,node=' + node.name + ',*');
	AdminControl.invoke(sync, 'sync');
for node in deployed.supportingInfrastructure:
	sync = AdminControl.completeObjectName('type=NodeSync,node=' + node.name + ',*');
	AdminControl.invoke(sync, 'sync');
for node in deployed.applicationDeploymentTarget:
	sync = AdminControl.completeObjectName('type=NodeSync,node=' + node.name + ',*');
	AdminControl.invoke(sync, 'sync');

print 'Deployment environment generated. All done'

