package com.xebialabs.deployit.plugin.wps.contributor;

import com.google.common.base.Predicate;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

public class WpsEarModulePredicate implements Predicate<Delta> {

    public static final String WPS_EAR_Module = "wps.EarModule";

    private  Type wpsType;

    public WpsEarModulePredicate() {
        wpsType  = Type.valueOf(WPS_EAR_Module);
    }

    @Override
    public boolean apply(final Delta input) {
        Deployed<?,?> deployed = input.getDeployed();
        if (deployed == null) {
            deployed = input.getPrevious();
        }

        return deployed.getType().instanceOf(wpsType);
    }

}
