import os.path
import jarray
import java.io.File as File
from java.io import *
import javax.management as mgmt
import zipfile

def getInternalProcessContainerMBean(container):
	return findBPCMBeans(container)["processMBeans"][0]

def deployQueryTableJar(container, jarPath, operation):
	print "Deploying query tables in jar %s" % (os.path.basename(jarPath))
	jar=java.io.File(jarPath)
	jarFis=java.io.FileInputStream(jar)
	fileAsBlob=jarray.zeros(jar.length(),'b')
	jarFis.read(fileAsBlob)
	jarFis.close()
	params = jarray.array([fileAsBlob],java.lang.Object)
	signature = ['[B']
	mbean = getInternalProcessContainerMBean(container)
	AdminControl.invoke_jmx(mgmt.ObjectName(mbean), operation, params, signature)

def extractQueryTableName(fileName):
	return os.path.basename(os.path.splitext(fileName)[0])

def undeployQueryTableJar(container, jarPath):
	jarFile=zipfile.ZipFile(jarPath)
	qtdFileNames = [i for i in jarFile.namelist() if i.endswith(".qtd")]
	qtdTableNames = map(extractQueryTableName, qtdFileNames)
	qtdTableNames.sort()
	qtdTableNames.reverse()
	mbean = getInternalProcessContainerMBean(container)
	for qtdTable in qtdTableNames:
		print "Undeploying query table %s" % qtdTable
		params = '["%s" "null"]' % (str(qtdTable))
		AdminControl.invoke(mbean, "undeployQueryTable", params)


		
	
	
	