package com.xebialabs.deployit.plugin.wmq.deployed;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.generic.deployed.ExecutedScript;

@SuppressWarnings("serial")
@Metadata(virtual=true)
public class Resource<D extends Deployable> extends ExecutedScript<D> {

    @Property(hidden = true, defaultValue = "deployable, container, createOrder, createScript, createVerb, modifyOrder, modifyScript, modifyVerb, destroyOrder, destroyScript, "
            + "destroyVerb, startOrder, startScript, startVerb, stopOrder, stopScript, stopVerb, inspectScript, inspectVerb, securityPermissions, inheritPermissions, provisioners, ordinal, boundConfigurationItems", description = "Standard properties that are not exposed to any python wsadmin script.")
    private String standardPropertiesNotToExpose;

    public String getParameters() {
        StringBuilder sb = new StringBuilder();
        for (Iterator<Map.Entry<String, Object>> iter = getFilteredProperties().entrySet().iterator(); iter.hasNext();) {
            Entry<String, Object> eachProperty = iter.next();
            sb.append(eachProperty.getKey().toUpperCase());
            sb.append("(");
            sb.append(quote(eachProperty.getValue()));
            sb.append(")");
            if (iter.hasNext()) {
                sb.append(" ");
            }
        }
        //System.err.println("Command parameters:" + sb.toString());
        return sb.toString();
    }

    private Object quote(Object value) {
        if (value instanceof String) {
            String txt = (String) value;
            String trimmedTxt = txt.trim();
            return "'"  + value + "'";
        }
        return value;
    }

    private Map<String, Object> getFilteredProperties() {
        final Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
        Map<String, Object> parameters = new HashMap<String, Object>();
        Set<String> propertiesNotToBeExposed = new HashSet<String>(Arrays.asList(standardPropertiesNotToExpose.split(", ")));
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (pd.isHidden() || getProperty(pd.getName()) == null || propertiesNotToBeExposed.contains(pd.getName())) {
                continue;
            }
            parameters.put(pd.getName(), getProperty(pd.getName()));
        }
        return parameters;
    }

}
