import urllib
from wlp.modules.mbean.connector import JMXSSLConnector


class GeneratePluginConfigMBean(object):
    def __init__(self, container):
        self.connector = JMXSSLConnector(container)

    def generate_default_plugin_config(self):
        # curl -u wlpadmin:wlpadmin -k --data '{}' -H "Content-Type:application/json" --request POST https://10.10.10.80:9443/IBMJMXConnectorREST/mbeans/WebSphere%3Aname%3Dcom.ibm.ws.jmx.mbeans.generatePluginConfig/operations/generateDefaultPluginConfig
        self.connector.send("POST", self._mbean_url("generateDefaultPluginConfig"))

    @staticmethod
    def _mbean_url(operation):
        return urllib.quote("/IBMJMXConnectorREST/mbeans/WebSphere:name=com.ibm.ws.jmx.mbeans.generatePluginConfig/operations/%s" % (operation))
