#
from java.util import HashSet
from com.xebialabs.deployit.plugin.api.deployment.planning import DefaultOrders


def containers():
    result = HashSet()
    for delta in deltas.deltas:
        deployed = delta.deployedOrPrevious
        current_container = deployed.container
        if delta.operation != "NOOP" and current_container.type == "wlp.Server" and current_container.reloadServerConfiguration is True:
            result.add(current_container)
    return result


for container in containers():
    context.addStep(steps.jython(
        description="Reload configuration on server '%s'" % container.name,
        order=DefaultOrders.START_ARTIFACTS - 1,
        script="wlp/scripts/container/server-reload-configuration.py",
        jython_context={"thisCi": container}
    ))