from __future__ import with_statement
from wlp.modules.overthere import OverthereHostSession
from wlp.modules.configuration import Configuration
from wlp.modules.utility import Paths

with OverthereHostSession(deployed.container.host) as session:
    print "Creating %s '%s' in container '%s'" % (deployed.type.name, deployed.name, deployed.container.name)
    server_xml_path = Paths.get_server_xml_path(deployed)
    configuration = Configuration(session.read_file(server_xml_path))
    configuration.create_or_update_resource(deployed)
    session.write_file(configuration.to_string(), server_xml_path)
    print "%s '%s' successfully created" % (deployed.type.name, deployed.name)
