#
import sys
from com.xebialabs.deployit.plugin.api.deployment.planning import DefaultOrders

class ResourceUtil():
    def __init__(self):
        pass

    @staticmethod
    def getCreateOrder(deployed):
        if deployed.hasProperty('createOrder'):
            return deployed.getProperty('createOrder')
        return DefaultOrders.CREATE_RESOURCES

    @staticmethod
    def getDestroyOrder(deployed):
        if deployed.hasProperty('destroyOrder'):
            return deployed.getProperty('destroyOrder')
        return DefaultOrders.DESTROY_RESOURCES

class Logger():
    def __init__(self):
        pass

    @staticmethod
    def log_and_raise_error(msg):
        print >> sys.stderr, msg
        raise Exception(msg)

class Paths():
    def __init__(self):
        pass

    @staticmethod
    def get_target_path(deployed):
        if Paths._isabs(deployed.container, deployed.location):
            return deployed.location
        else:
            return Paths._join(deployed.container, Paths.get_server_config_dir(deployed.container), "apps", deployed.location)

    @staticmethod
    def get_server_xml_path(deployed):
        return Paths._join(deployed.container, Paths.get_server_config_dir(deployed.container), "server.xml")

    @staticmethod
    def get_server_config_dir(container):
        return container.serverConfigDir if container.serverConfigDir else Paths._join(container, container.wlpInstallDir, "usr", "servers", container.name)

    # private

    @staticmethod
    def _join(container, *args):
        return container.host.os.fileSeparator.join(args)

    @staticmethod
    def _isabs(container, path):
        print container
        os_name = container.host.os.name()
        return (os_name != "WINDOWS" and path.startswith('/')) or (os_name == "WINDOWS" and (path.startswith("\\\\") or path.find(":\\")))
