#
import urllib
from wlp.modules.mbean.connector import JMXSSLConnector
from wlp.modules.utility import Logger
import time


class ApplicationMBean(object):
    def __init__(self, container):
        self.connector = JMXSSLConnector(container)

    def start_application(self, application):
        self._change_state(application, "start", "STARTED")

    def stop_application(self, application):
        self._change_state(application, "stop", "STOPPED")

    def get_state(self, application):
        state = None
        for retry in range(1, 15):
            result = self.connector.send("GET", self._mbean_url(application, "attributes/State"), throw_on_failure=False)
            if result.is_success():
                state = result.get("value")
                break
            else:
                if "InstanceNotFoundException" in result.text:
                    if retry == 1:
                        print "Waiting for application '%s' to respond" % application
                    time.sleep(2)
                else:
                    result.throw_on_failure()

        if not state:
            Logger.log_and_raise_error("Application '%s' not found, please check that the application is installed on the server" % application)

        print "Current state of application: %s" % state
        return state

    # private

    @staticmethod
    def _mbean_url(application, query):
        return urllib.quote("/IBMJMXConnectorREST/mbeans/WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=%s/%s" % (application, query))

    def _wait_for_state(self, application, state):
        for retry in range(1, 30):
            current_state = self.get_state(application)
            if current_state == state:
                print "Application '%s' reached state '%s'" % (application, state)
                return
            print "Waiting for state '%s'. Current state is '%s'" % (state, current_state)
            time.sleep(2)
        Logger.log_and_raise_error("Application '%s' never reached terminal state '%s'" % (application, state))

    def _change_state(self, application, operation, state):
        current_state = self.get_state(application)
        if current_state == state:
            print "Application '%s' already in state '%s'" % (application, state)
        else:
            print "Invoke '%s' operation on application '%s'" % (operation, application)
            self.connector.send("POST", self._mbean_url(application, "operations/%s" % operation))
            self._wait_for_state(application, state)