/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wlp.validator;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="wlp-singleton-collection")
@ApplicableTo(value={PropertyKind.SET_OF_CI, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_CI, PropertyKind.LIST_OF_STRING, PropertyKind.MAP_STRING_STRING})
@Target(value={ElementType.FIELD})
public @interface SingletonCollection {
    public static final String DEFAULT_MESSAGE = "The collection property can not contain more than 1 item, found: %s";

    public String message() default "The collection property can not contain more than 1 item, found: %s";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Object> {
        private String message = "The collection property can not contain more than 1 item, found: %s";

        public void validate(Object value, ValidationContext context) {
            int size = ((Collection)value).size();
            if (size != 1 && size != 0) {
                context.error(this.message, new Object[]{size});
            }
        }
    }
}

