from wlp.modules.overthere import OverthereHostSession
from wlp.modules.utility import Paths, Logger

if not thisCi.wlpInstallDir or not thisCi.name:
    Logger.log_and_raise_error("ERROR: ensure properties wlpInstallDir and name are defined. Will not proceed.")

with OverthereHostSession(thisCi.host) as session:
    server_config_dir = Paths.get_server_config_dir(thisCi)
    remoteDir = session.remote_file(server_config_dir)

    if remoteDir.exists():
        if remoteDir.isDirectory():
            try:
                remoteDir.deleteRecursively()
                print "Deleted %s" % server_config_dir
            except:
                Logger.log_and_raise_error("Unable to delete %s" % server_config_dir)
        else:
            Logger.log_and_raise_error("%s is not a directory" % server_config_dir)
    else:
        print "Directory %s does not exist" % server_config_dir
