$shareName = if($deployed.shareName) { $deployed.shareName } else { $deployed.name }

Write-Host "Creating share [$shareName] to [$($deployed.targetPath)]"
$shares = [WMICLASS]"WIN32_Share"
$res = $shares.Create($deployed.targetPath, $shareName, 0)

if ($res.ReturnValue -ne 0) {
    Write-Host "Cannot create share [$shareName] (error code $($res.ReturnValue))"
    Exit $res.ReturnValue
}
