# Uninstall the MSI
$msiLog = "msiexec-log.txt"

$msiArgs = @()
$msiArgs += "/x"
$msiArgs += $deployed.file
if ($deployed.additionalUninstallProperties) {
    $msiArgs += $deployed.additionalUninstallProperties
}
if ($deployed.logOptions) {
    $msiArgs += "/L$($deployed.logOptions) $msiLog"
}
$msiArgs += "/qn"

Write-Host "Uninstalling MSI [$($deployed.name)] with arguments [$($msiArgs)]"
$process = Start-Process -FilePath msiexec -ArgumentList $msiArgs -Wait -PassThru

if(!$?) {
    Write-Host "Cannot start uninstallation of MSI"
    Exit 1
}

if ($deployed.logOptions) {
    Write-Host ""
    Get-Content $msiLog
    Write-Host ""
    Remove-Item $msiLog
}

if ($process.ExitCode -eq 0){
    Write-Host "MSI has successfully been uninstalled."
} else {
    Write-Host "Uninstallation of MSI failed with exit code $($process.ExitCode)."
    Exit $process.ExitCode
}
