# Install the MSI
$msiLog = "msiexec-log.txt"

$msiArgs = @()
$msiArgs += "/i"
$msiArgs += $deployed.file
if ($deployed.additionalInstallProperties) {
	$msiArgs += $deployed.additionalInstallProperties
}
if ($deployed.logOptions) {
	$msiArgs += "/L$($deployed.logOptions) $msiLog"
}
$msiArgs += "/qn"

Write-Host "Installing MSI [$($deployed.name)] with arguments [$($msiArgs)]"
$process = Start-Process -FilePath msiexec -ArgumentList $msiArgs -Wait -PassThru

if(!$?) {
	Write-Host "Cannot start installation of MSI"
	Exit 1
}

if ($deployed.logOptions) {
	Write-Host ""
	Get-Content $msiLog
	Write-Host ""
	Remove-Item $msiLog
}

if ($process.ExitCode -eq 0){
    Write-Host "MSI has successfully been installed."
} else {
    Write-Host "Installation of MSI failed with exit code $($process.ExitCode)."
    Exit $process.ExitCode
}
