# Uninstall the MSI
$msiLog = "msiexec-log.txt"

$msiArgs = @()
$msiArgs += "/x"
$msiArgs += $deployed.file
if ($deployed.additionalUninstallProperties) {
    $msiArgs += $deployed.additionalUninstallProperties
}
if ($deployed.logOptions) {
    $msiArgs += "/L$($deployed.logOptions) $msiLog"
}
$msiArgs += "/qn"

Write-Output "Uninstalling MSI [$($deployed.name)] with arguments [$($msiArgs)]"
$process = Start-Process -FilePath msiexec -ArgumentList $msiArgs -Wait -PassThru

if(!$?) {
    Write-Output "Cannot start uninstallation of MSI"
    Exit 1
}

if ($deployed.logOptions) {
    Write-Output ""
    Get-Content $msiLog
    Write-Output ""
    Remove-Item $msiLog
}

if ($process.ExitCode -eq 0){
    Write-Output "MSI has successfully been uninstalled."
} else {
    Write-Output "Uninstallation of MSI failed with exit code $($process.ExitCode)."
    Exit $process.ExitCode
}
