$serviceName = if($deployed.serviceName) { $deployed.serviceName } else { $deployed.name }

function Start-Service-With-Timeout($serviceName, $timeout) {

    $scriptBlock = {
        param($serviceName)
        Start-Service -Name $serviceName -ErrorAction SilentlyContinue -WarningAction SilentlyContinue
    }

    $job = Start-Job -ScriptBlock $scriptBlock -ArgumentList $ServiceName
    Wait-Job -Job $job -Timeout $timeout | Out-Null

    if ((Get-Service -Name $ServiceName).Status -ne "Running") {
        Write-Output "Cannot start service [$ServiceName]. Please check the Services control panel and the Event Viewer."
        Exit 1
    }

    # Wait for file handles to be released
    Start-Sleep -Seconds 1
}

if($deployed.startupType -eq "Disabled") {
    Write-Output "Not starting service [$serviceName] because it has been disabled."
} else {
    Write-Output "Starting service [$serviceName]."
    Start-Service-With-Timeout $serviceName $deployed.startTimeout
}
