# Install the MSI
$msiLog = "msiexec-log.txt"

$msiArgs = @()
$msiArgs += "/i"
$msiArgs += $deployed.file
if ($deployed.additionalInstallProperties) {
	$msiArgs += $deployed.additionalInstallProperties
}
if ($deployed.logOptions) {
	$msiArgs += "/L$($deployed.logOptions) $msiLog"
}
$msiArgs += "/qn"

Write-Output "Installing MSI [$($deployed.name)] with arguments [$($msiArgs)]"
$process = Start-Process -FilePath msiexec -ArgumentList $msiArgs -Wait -PassThru

if(!$?) {
	Write-Output "Cannot start installation of MSI"
	Exit 1
}

if ($deployed.logOptions) {
	Write-Output ""
	Get-Content $msiLog
	Write-Output ""
	Remove-Item $msiLog
}

if ($process.ExitCode -eq 0){
    Write-Output "MSI has successfully been installed."
} else {
    Write-Output "Installation of MSI failed with exit code $($process.ExitCode)."
    Exit $process.ExitCode
}
